/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.types;

import graphql.schema.GraphQLScalarType;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.causeway.viewer.graphql.applib.marshallers.ScalarMarshaller;
import org.apache.causeway.viewer.graphql.model.types.ScalarMapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
public class ScalarMapperUsingScalarMarshallers
implements ScalarMapper {
    private final List<ScalarMarshaller<?>> scalarMarshallers;
    final Map<Class<?>, ScalarMarshaller<?>> scalarMarshallerByClass = new HashMap();

    @Override
    public GraphQLScalarType scalarTypeFor(Class<?> clazz) {
        return this.scalarMarshallerFor(clazz).getGqlScalarType();
    }

    @Override
    public Object unmarshal(Object argumentValue, Class<?> targetType) {
        ScalarMarshaller<?> scalarMarshaller = this.scalarMarshallerFor(targetType);
        return scalarMarshaller.unmarshal(argumentValue, targetType);
    }

    private ScalarMarshaller<?> scalarMarshallerFor(Class<?> c) {
        return this.scalarMarshallerByClass.computeIfAbsent(c, cls -> {
            for (ScalarMarshaller<?> scalarMarshaller : this.scalarMarshallers) {
                if (!scalarMarshaller.handles(cls)) continue;
                return scalarMarshaller;
            }
            throw new IllegalArgumentException("Could not locate a ScalarMarshaller to handle class " + c);
        });
    }

    @Inject
    @Generated
    public ScalarMapperUsingScalarMarshallers(List<ScalarMarshaller<?>> scalarMarshallers) {
        this.scalarMarshallers = scalarMarshallers;
    }

    @Configuration
    public static class AutoConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={ScalarMapperUsingScalarMarshallers.class})
        public ScalarMapper defaultScalarMapper(List<ScalarMarshaller<?>> scalarMarshallers) {
            return new ScalarMapperUsingScalarMarshallers(scalarMarshallers);
        }
    }
}

