/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.common.SchemaStrategy;
import org.apache.causeway.viewer.graphql.model.domain.common.query.CommonTopLevelQueryAbstract;
import org.apache.causeway.viewer.graphql.model.domain.rich.scenario.Scenario;

public class RichTopLevelQuery
extends CommonTopLevelQueryAbstract {
    private static final SchemaStrategy SCHEMA_STRATEGY = SchemaStrategy.RICH;
    private final Scenario scenario;

    public RichTopLevelQuery(Context context) {
        super(SCHEMA_STRATEGY, context);
        CausewayConfiguration.Viewer.Graphql graphqlConfiguration = context.causewayConfiguration.getViewer().getGraphql();
        if (graphqlConfiguration.getSchema().getRich().isEnableScenarioTesting()) {
            this.scenario = new Scenario(SCHEMA_STRATEGY, context);
            this.addChildFieldFor(this.scenario);
        } else {
            this.scenario = null;
        }
        this.buildObjectType();
        this.setField(GraphQLFieldDefinition.newFieldDefinition().name(SCHEMA_STRATEGY.topLevelFieldNameFrom(graphqlConfiguration)).type((GraphQLOutputType)this.getGqlObjectType()).build());
    }

    @Override
    protected void addDataFetchersForChildren() {
        super.addDataFetchersForChildren();
        if (this.scenario != null) {
            this.scenario.addDataFetcher(this);
        }
    }
}

