/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.simple.mutation;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLObjectType;
import java.util.ArrayList;
import java.util.List;
import org.apache.causeway.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.Parent;
import org.apache.causeway.viewer.graphql.model.domain.simple.mutation.SimpleMutationForAction;
import org.apache.causeway.viewer.graphql.model.domain.simple.mutation.SimpleMutationForProperty;

public class SimpleTopLevelMutation
extends ElementCustom
implements Parent {
    private final List<SimpleMutationForAction> actions = new ArrayList<SimpleMutationForAction>();
    private final List<SimpleMutationForProperty> properties = new ArrayList<SimpleMutationForProperty>();

    public SimpleTopLevelMutation(Context context) {
        super("Mutation", context);
        if (this.isBuilt()) {
            return;
        }
        List<? extends ObjectSpecification> objectSpecifications = context.objectSpecifications();
        objectSpecifications.forEach(objectSpec -> {
            objectSpec.streamActions(context.getActionScope(), MixedIn.INCLUDED).filter(x$0 -> this.inApiScope((ObjectAction)x$0)).filter(x -> !x.getSemantics().isSafeInNature()).forEach(objectAction -> this.addAction((ObjectSpecification)objectSpec, (ObjectAction)objectAction));
            objectSpec.streamProperties(MixedIn.INCLUDED).filter(property -> !property.isAlwaysHidden()).filter(x$0 -> this.inApiScope((ObjectAssociation)x$0)).filter(property -> property.containsFacet(PropertySetterFacet.class)).forEach(property -> this.addProperty((ObjectSpecification)objectSpec, (OneToOneAssociation)property));
        });
        this.buildObjectType();
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment environment) {
        return null;
    }

    public void addAction(ObjectSpecification objectSpec, ObjectAction objectAction) {
        SimpleMutationForAction gqlvMutationForAction = new SimpleMutationForAction(objectSpec, objectAction, this.context);
        this.addChildFieldFor(gqlvMutationForAction);
        this.actions.add(gqlvMutationForAction);
    }

    public void addProperty(ObjectSpecification objectSpec, OneToOneAssociation property) {
        SimpleMutationForProperty gqlvMutationForProperty = new SimpleMutationForProperty(objectSpec, property, this.context);
        this.addChildFieldFor(gqlvMutationForProperty);
        this.properties.add(gqlvMutationForProperty);
    }

    @Override
    public GraphQLObjectType getGqlObjectType() {
        return super.getGqlObjectType();
    }

    @Override
    public void addDataFetchers() {
        this.addDataFetchersForChildren();
    }

    @Override
    protected void addDataFetchersForChildren() {
        this.actions.forEach(simpleMutationForAction -> simpleMutationForAction.addDataFetcher(this));
        this.properties.forEach(simpleMutationForProperty -> simpleMutationForProperty.addDataFetcher(this));
    }
}

