/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.simple.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.causeway.core.metamodel.interactions.InteractionHead;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneFeature;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.Environment;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ObjectInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.query.ObjectFeatureUtils;
import org.apache.causeway.viewer.graphql.model.exceptions.DisabledException;
import org.apache.causeway.viewer.graphql.model.exceptions.HiddenException;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleAction
extends Element {
    @Generated
    private static final Logger log = LogManager.getLogger(SimpleAction.class);
    final ObjectInteractor objectInteractor;
    private final ObjectAction objectMember;

    public SimpleAction(ObjectInteractor objectInteractor, ObjectAction objectAction, Context context) {
        super(context);
        this.objectInteractor = objectInteractor;
        this.objectMember = objectAction;
        GraphQLOutputType graphQLOutputType = this.typeFor(objectAction);
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(this.getId()).description(objectAction.getCanonicalDescription().orElse(objectAction.getCanonicalFriendlyName())).type(graphQLOutputType);
        this.addGqlArguments(objectAction, fieldBuilder, TypeMapper.InputContext.INVOKE, objectAction.getParameterCount());
        this.setField(fieldBuilder.build());
    }

    public String getId() {
        return this.objectMember.asciiId();
    }

    private GraphQLOutputType typeFor(ObjectAction objectAction) {
        ObjectSpecification objectSpecification = objectAction.getReturnType();
        switch (objectSpecification.getBeanSort()) {
            case COLLECTION: {
                TypeOfFacet facet = (TypeOfFacet)objectAction.getFacet(TypeOfFacet.class);
                if (facet == null) {
                    log.warn("Unable to locate TypeOfFacet for {}", (Object)objectAction.getFeatureIdentifier().getFullIdentityString());
                    return null;
                }
                ObjectSpecification objectSpecificationOfCollectionElement = facet.elementSpec();
                GraphQLOutputType wrappedType = this.context.typeMapper.outputTypeFor(objectSpecificationOfCollectionElement, this.objectInteractor.getSchemaType());
                if (wrappedType == null) {
                    log.warn("Unable to create wrapped type of for {} for action {}", (Object)objectSpecificationOfCollectionElement.getFullIdentifier(), (Object)objectAction.getFeatureIdentifier().getFullIdentityString());
                    return null;
                }
                return GraphQLList.list((GraphQLType)wrappedType);
            }
        }
        return this.context.typeMapper.outputTypeFor(objectSpecification, this.objectInteractor.getSchemaType());
    }

    public Can<ManagedObject> argumentManagedObjectsFor(Environment dataFetchingEnvironment, ObjectAction objectAction, BookmarkService bookmarkService) {
        return SimpleAction.argumentManagedObjectsFor(dataFetchingEnvironment, objectAction, this.context);
    }

    public static Can<ManagedObject> argumentManagedObjectsFor(Environment environment, ObjectAction objectAction, Context context) {
        Map<String, Object> argumentPojos = environment.getArguments();
        Can parameters = objectAction.getParameters();
        return parameters.map(oap -> {
            ObjectSpecification elementType = oap.getElementType();
            Object argumentValue = argumentPojos.get(oap.asciiId());
            switch (elementType.getBeanSort()) {
                case VALUE: {
                    return SimpleAction.adaptValue(oap, argumentValue, context);
                }
                case ENTITY: 
                case VIEW_MODEL: {
                    if (argumentValue == null) {
                        return ManagedObject.empty((ObjectSpecification)elementType);
                    }
                }
                case ABSTRACT: {
                    List pojoOrPojoList;
                    if (argumentValue instanceof List) {
                        List argumentValueList = (List)argumentValue;
                        pojoOrPojoList = argumentValueList.stream().map(value -> SimpleAction.asPojo(oap.getElementType(), value, environment, context)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                    } else {
                        pojoOrPojoList = SimpleAction.asPojo(oap.getElementType(), argumentValue, environment, context).orElse(null);
                    }
                    return ManagedObject.adaptParameter((ObjectActionParameter)oap, pojoOrPojoList);
                }
            }
            throw new IllegalArgumentException(String.format("Cannot handle an input type for %s; beanSort is %s", elementType.getFullIdentifier(), elementType.getBeanSort()));
        });
    }

    private static ManagedObject adaptValue(ObjectActionParameter oap, Object argumentValue, Context context) {
        ObjectSpecification elementType = oap.getElementType();
        if (argumentValue == null) {
            return ManagedObject.empty((ObjectSpecification)elementType);
        }
        Object argPojo = context.typeMapper.unmarshal(argumentValue, elementType);
        return ManagedObject.adaptParameter((ObjectActionParameter)oap, (Object)argPojo);
    }

    public static Optional<Object> asPojo(ObjectSpecification elementType, Object argumentValueObj, Environment environment, Context context) {
        Map argumentValue = (Map)argumentValueObj;
        String refValue = (String)argumentValue.get("ref");
        if (refValue != null) {
            String key = ObjectFeatureUtils.keyFor(refValue);
            BookmarkedPojo bookmarkedPojo = (BookmarkedPojo)environment.getGraphQlContext().get((Object)key);
            if (bookmarkedPojo == null) {
                throw new IllegalArgumentException(String.format("Could not find object referenced '%s' in the execution context; was it saved previously using \"saveAs\" ?", refValue));
            }
            Class<?> targetPojoClass = bookmarkedPojo.getTargetPojo().getClass();
            ObjectSpecification targetPojoSpec = context.specificationLoader.loadSpecification(targetPojoClass);
            if (targetPojoSpec == null) {
                throw new IllegalArgumentException(String.format("The object referenced '%s' is not part of the metamodel (has class '%s')", refValue, targetPojoClass.getCanonicalName()));
            }
            if (!elementType.isPojoCompatible(bookmarkedPojo.getTargetPojo())) {
                throw new IllegalArgumentException(String.format("The object referenced '%s' has a type '%s' that is not assignable to the required type '%s'", refValue, targetPojoSpec.logicalTypeName(), elementType.logicalTypeName()));
            }
            return Optional.of(bookmarkedPojo).map(BookmarkedPojo::getTargetPojo);
        }
        String idValue = (String)argumentValue.get("id");
        if (idValue != null) {
            Optional<Bookmark> bookmarkIfAny;
            Class paramClass = elementType.getCorrespondingClass();
            if (elementType.isAbstract()) {
                ObjectSpecification objectSpecArg = (ObjectSpecification)argumentValue.get("logicalTypeName");
                if (objectSpecArg == null) {
                    throw new IllegalArgumentException(String.format("The 'logicalTypeName' is required along with the 'id', because the input type '%s' is abstract", elementType.logicalTypeName()));
                }
                bookmarkIfAny = Optional.of(Bookmark.forLogicalTypeNameAndIdentifier((String)objectSpecArg.logicalTypeName(), (String)idValue));
            } else {
                bookmarkIfAny = context.bookmarkService.bookmarkFor(paramClass, idValue);
            }
            return bookmarkIfAny.map(arg_0 -> ((BookmarkService)context.bookmarkService).lookup(arg_0)).filter(Optional::isPresent).map(Optional::get);
        }
        throw new IllegalArgumentException("Either 'id' or 'ref' must be specified for a DomainObject input type");
    }

    public void addGqlArguments(ObjectAction objectAction, GraphQLFieldDefinition.Builder builder, TypeMapper.InputContext inputContext, int upTo) {
        Can parameters = objectAction.getParameters();
        List arguments = parameters.stream().limit(upTo).map(objectActionParameter -> this.gqlArgumentFor((ObjectActionParameter)objectActionParameter, inputContext)).collect(Collectors.toList());
        if (!arguments.isEmpty()) {
            builder.arguments(arguments);
        }
    }

    GraphQLArgument gqlArgumentFor(ObjectActionParameter objectActionParameter, TypeMapper.InputContext inputContext) {
        return objectActionParameter.isPlural() ? this.gqlArgumentFor((OneToManyActionParameter)objectActionParameter) : this.gqlArgumentFor((OneToOneActionParameter)objectActionParameter, inputContext);
    }

    GraphQLArgument gqlArgumentFor(OneToOneActionParameter otoap, TypeMapper.InputContext inputContext) {
        return GraphQLArgument.newArgument().name(otoap.asciiId()).type(this.context.typeMapper.inputTypeFor((OneToOneFeature)otoap, inputContext, this.objectInteractor.getSchemaType())).build();
    }

    GraphQLArgument gqlArgumentFor(OneToManyActionParameter otmap) {
        return GraphQLArgument.newArgument().name(otmap.asciiId()).type((GraphQLInputType)this.context.typeMapper.inputTypeFor(otmap, this.objectInteractor.getSchemaType())).build();
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        Can<ManagedObject> argumentManagedObjects;
        ManagedObject managedObject;
        Object sourcePojo = BookmarkedPojo.sourceFrom(dataFetchingEnvironment);
        Environment.For environment = new Environment.For(dataFetchingEnvironment);
        ObjectSpecification objectSpecification = this.context.specificationLoader.loadSpecification(sourcePojo.getClass());
        if (objectSpecification == null) {
            return null;
        }
        ObjectAction objectAction = this.getObjectMember();
        Consent visibleConsent = objectAction.isVisible(managedObject = ManagedObject.adaptSingular((ObjectSpecification)objectSpecification, (Object)sourcePojo), InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (visibleConsent.isVetoed()) {
            throw new HiddenException(objectAction.getFeatureIdentifier());
        }
        Consent usableConsent = objectAction.isUsable(managedObject, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (usableConsent.isVetoed()) {
            throw new DisabledException(objectAction.getFeatureIdentifier());
        }
        InteractionHead head = objectAction.interactionHead(managedObject);
        Consent validityConsent = objectAction.isArgumentSetValid(head, argumentManagedObjects = this.argumentManagedObjectsFor(environment, objectAction, this.context.bookmarkService), InteractionInitiatedBy.USER);
        if (validityConsent.isVetoed()) {
            throw new IllegalArgumentException(validityConsent.getReasonAsString().orElse("Invalid"));
        }
        ManagedObject resultManagedObject = objectAction.execute(head, argumentManagedObjects, InteractionInitiatedBy.USER);
        return resultManagedObject.getPojo();
    }

    @Generated
    public ObjectInteractor getObjectInteractor() {
        return this.objectInteractor;
    }

    @Generated
    public ObjectAction getObjectMember() {
        return this.objectMember;
    }
}

