/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.applib;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.io.JsonUtils;
import org.apache.causeway.viewer.restfulobjects.applib.LinkRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.util.JsonNodeUtils;
import org.apache.causeway.viewer.restfulobjects.applib.util.PathNode;
import org.apache.causeway.viewer.restfulobjects.applib.util.UrlEncodingUtils;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.lang.Nullable;

public class JsonRepresentation {
    private static final Pattern FORMAT_BIG_DECIMAL = Pattern.compile("big-decimal\\((\\d+),(\\d+)\\)");
    private static final Pattern FORMAT_BIG_INTEGER = Pattern.compile("big-integer\\((\\d+)\\)");
    private static Map<Class<?>, Function<JsonNode, ?>> REPRESENTATION_INSTANTIATORS = _Maps.newHashMap();
    protected final JsonNode jsonNode;
    public static final DateTimeFormatter yyyyMMdd;
    public static final DateTimeFormatter yyyyMMddTHHmmssZ;
    public static final DateTimeFormatter _HHmmss;
    private static final Function<Map.Entry<String, JsonNode>, Map.Entry<String, JsonRepresentation>> MAP_ENTRY_JSON_NODE_TO_JSON_REPRESENTATION;

    private static <T> Function<JsonNode, ?> representationInstantiatorFor(Class<T> representationType) {
        Function<JsonNode, Object> transformer = REPRESENTATION_INSTANTIATORS.get(representationType);
        if (transformer == null) {
            transformer = input -> {
                try {
                    Constructor constructor = representationType.getConstructor(JsonNode.class);
                    return constructor.newInstance(input);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Conversions from JsonNode to " + String.valueOf(representationType) + " are not supported");
                }
            };
            REPRESENTATION_INSTANTIATORS.put(representationType, transformer);
        }
        return transformer;
    }

    public static JsonRepresentation jsonAsMap(@Nullable String keyValuePairsAsJson) {
        JsonRepresentation repr = JsonRepresentation.newMap(new String[0]);
        if (_Strings.isNotEmpty((CharSequence)keyValuePairsAsJson)) {
            Map keyValuePairs = (Map)_Casts.uncheckedCast(JsonUtils.tryRead(Map.class, (String)keyValuePairsAsJson, (JsonUtils.JacksonCustomizer[])new JsonUtils.JacksonCustomizer[0]).ifFailureFail().getValue().orElseThrow());
            keyValuePairs.forEach((key, value) -> repr.mapPutString(String.valueOf(key), String.valueOf(value)));
        }
        return repr;
    }

    public static JsonRepresentation newMap(String ... keyValuePairs) {
        JsonRepresentation repr = new JsonRepresentation((JsonNode)new ObjectNode(JsonNodeFactory.instance));
        String key = null;
        for (String keyOrValue : keyValuePairs) {
            if (key != null) {
                repr.mapPutString(key, keyOrValue);
                key = null;
                continue;
            }
            key = keyOrValue;
        }
        if (key != null) {
            throw new IllegalArgumentException("must provide an even number of keys and values");
        }
        return repr;
    }

    public static JsonRepresentation newArray() {
        return JsonRepresentation.newArray(0);
    }

    public static JsonRepresentation newArray(int initialSize) {
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        for (int i = 0; i < initialSize; ++i) {
            arrayNode.addNull();
        }
        return new JsonRepresentation((JsonNode)arrayNode);
    }

    public JsonRepresentation(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public JsonNode asJsonNode() {
        return this.jsonNode;
    }

    public int size() {
        if (!this.isMap() && !this.isArray()) {
            throw new IllegalStateException("not a map or an array");
        }
        return this.jsonNode.size();
    }

    public boolean isValue() {
        return this.jsonNode.isValueNode();
    }

    public JsonRepresentation getRepresentation(String pathTemplate, Object ... args) {
        String pathStr = String.format(pathTemplate, args);
        JsonNode node = this.getNode(pathStr);
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        return new JsonRepresentation(node);
    }

    public boolean isArray(String path) {
        return this.isArray(this.getNode(path));
    }

    public boolean isArray() {
        return this.isArray(this.asJsonNode());
    }

    private boolean isArray(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isArray();
    }

    public JsonRepresentation getArray(String path) {
        return this.getArray(path, this.getNode(path));
    }

    public JsonRepresentation asArray() {
        return this.getArray(null, this.asJsonNode());
    }

    private JsonRepresentation getArray(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        if (!this.isArray(node)) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not an array"));
        }
        return new JsonRepresentation(node);
    }

    public JsonRepresentation getArrayEnsured(String path) {
        return this.getArrayEnsured(path, this.getNode(path));
    }

    private JsonRepresentation getArrayEnsured(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        return new JsonRepresentation(node).ensureArray();
    }

    public boolean isMap(String path) {
        return this.isMap(this.getNode(path));
    }

    public boolean isMap() {
        return this.isMap(this.asJsonNode());
    }

    private boolean isMap(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && !node.isArray() && !node.isValueNode();
    }

    public JsonRepresentation getMap(String path) {
        return this.getMap(path, this.getNode(path));
    }

    public JsonRepresentation asMap() {
        return this.getMap(null, this.asJsonNode());
    }

    private JsonRepresentation getMap(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        if (this.isArray(node) || node.isValueNode()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a map"));
        }
        return new JsonRepresentation(node);
    }

    public boolean isNumber(String path) {
        return this.isNumber(this.getNode(path));
    }

    public boolean isNumber() {
        return this.isNumber(this.asJsonNode());
    }

    private boolean isNumber(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isNumber();
    }

    public Number asNumber() {
        return this.getNumber(null, this.asJsonNode());
    }

    private Number getNumber(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a number");
        if (!node.isNumber()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a number"));
        }
        return node.numberValue();
    }

    public boolean isIntegralNumber(String path) {
        return this.isIntegralNumber(this.getNode(path));
    }

    public boolean isIntegralNumber() {
        return this.isIntegralNumber(this.asJsonNode());
    }

    private boolean isIntegralNumber(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isIntegralNumber();
    }

    public Date getDate(String path) {
        return this.getDate(path, this.getNode(path));
    }

    public Date asDate() {
        return this.getDate(null, this.asJsonNode());
    }

    private Date getDate(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a date");
        if (!node.isTextual()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a date"));
        }
        String textValue = node.textValue();
        return new Date(yyyyMMdd.parseMillis(textValue));
    }

    public Date getDateTime(String path) {
        return this.getDateTime(path, this.getNode(path));
    }

    public Date asDateTime() {
        return this.getDateTime(null, this.asJsonNode());
    }

    private Date getDateTime(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a date-time");
        if (!node.isTextual()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a date-time"));
        }
        String textValue = node.textValue();
        return new Date(yyyyMMddTHHmmssZ.parseMillis(textValue));
    }

    public Date getTime(String path) {
        return this.getTime(path, this.getNode(path));
    }

    public Date asTime() {
        return this.getTime(null, this.asJsonNode());
    }

    private Date getTime(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a time");
        if (!node.isTextual()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a time"));
        }
        String textValue = node.textValue();
        LocalTime localTime = _HHmmss.parseLocalTime(textValue + "Z");
        return new Date(localTime.getMillisOfDay());
    }

    public boolean isBoolean(String path) {
        return this.isBoolean(this.getNode(path));
    }

    public boolean isBoolean() {
        return this.isBoolean(this.asJsonNode());
    }

    private boolean isBoolean(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isBoolean();
    }

    public Boolean getBoolean(String path) {
        return this.getBoolean(path, this.getNode(path));
    }

    public Boolean asBoolean() {
        return this.getBoolean(null, this.asJsonNode());
    }

    private Boolean getBoolean(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a boolean");
        if (!node.isBoolean()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a boolean"));
        }
        return node.booleanValue();
    }

    public Byte getByte(String path) {
        JsonNode node = this.getNode(path);
        return this.getByte(path, node);
    }

    public Byte asByte() {
        return this.getByte(null, this.asJsonNode());
    }

    private Byte getByte(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "an byte");
        if (!node.isNumber()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a number"));
        }
        return node.numberValue().byteValue();
    }

    public Short getShort(String path) {
        JsonNode node = this.getNode(path);
        return this.getShort(path, node);
    }

    public Short asShort() {
        return this.getShort(null, this.asJsonNode());
    }

    private Short getShort(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "an short");
        if (!node.isNumber()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a number"));
        }
        return node.shortValue();
    }

    public Character getChar(String path) {
        JsonNode node = this.getNode(path);
        return this.getChar(path, node);
    }

    public Character asChar() {
        return this.getChar(null, this.asJsonNode());
    }

    private Character getChar(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "an short");
        if (!node.isTextual()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not textual"));
        }
        String textValue = node.textValue();
        if (textValue == null || textValue.length() == 0) {
            return null;
        }
        return Character.valueOf(textValue.charAt(0));
    }

    public boolean isInt(String path) {
        return this.isInt(this.getNode(path));
    }

    public boolean isInt() {
        return this.isInt(this.asJsonNode());
    }

    private boolean isInt(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isInt();
    }

    public Integer getInt(String path) {
        JsonNode node = this.getNode(path);
        return this.getInt(path, node);
    }

    public Integer asInt() {
        return this.getInt(null, this.asJsonNode());
    }

    private Integer getInt(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "an int");
        if (!node.isInt()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not an int"));
        }
        return node.intValue();
    }

    public boolean isLong(String path) {
        return this.isLong(this.getNode(path));
    }

    public boolean isLong() {
        return this.isLong(this.asJsonNode());
    }

    private boolean isLong(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isLong();
    }

    public Long getLong(String path) {
        JsonNode node = this.getNode(path);
        return this.getLong(path, node);
    }

    public Long asLong() {
        return this.getLong(null, this.asJsonNode());
    }

    private Long getLong(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a long");
        if (node.isInt()) {
            return node.intValue();
        }
        if (node.isLong()) {
            return node.longValue();
        }
        throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a long"));
    }

    public Float getFloat(String path) {
        JsonNode node = this.getNode(path);
        return this.getFloat(path, node);
    }

    public Float asFloat() {
        return this.getFloat(null, this.asJsonNode());
    }

    private Float getFloat(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a float");
        if (!node.isNumber()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a number"));
        }
        return Float.valueOf(node.floatValue());
    }

    public boolean isDecimal(String path) {
        return this.isDecimal(this.getNode(path));
    }

    public boolean isDecimal() {
        return this.isDecimal(this.asJsonNode());
    }

    private boolean isDecimal(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && (node.isDouble() || node.isFloat());
    }

    public Double getDouble(String path) {
        JsonNode node = this.getNode(path);
        return this.getDouble(path, node);
    }

    public Double asDouble() {
        return this.getDouble(null, this.asJsonNode());
    }

    private Double getDouble(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a double");
        if (!node.isDouble()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a double"));
        }
        return node.doubleValue();
    }

    public boolean isBigInteger(String path) {
        return this.isBigInteger(this.getNode(path));
    }

    public boolean isBigInteger() {
        return this.isBigInteger(this.asJsonNode());
    }

    private boolean isBigInteger(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && (node.isBigInteger() || node.isLong() || node.isInt() || node.isTextual() && JsonRepresentation.parseableAsBigInteger(node.textValue()));
    }

    private static boolean parseableAsBigInteger(String str) {
        try {
            new BigInteger(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BigInteger getBigInteger(String path) {
        return this.getBigInteger(path, (String)null);
    }

    public BigInteger getBigInteger(String path, String formatRequested) {
        String format;
        JsonNode node;
        if (formatRequested != null) {
            node = this.getNode(path);
            format = formatRequested;
        } else {
            NodeAndFormat nodeAndFormat = this.getNodeAndFormat(path);
            node = nodeAndFormat.node;
            format = nodeAndFormat.format;
        }
        return this.getBigInteger(path, format, node);
    }

    public BigInteger asBigInteger() {
        return this.asBigInteger(null);
    }

    public BigInteger asBigInteger(String format) {
        return this.getBigInteger(null, format, this.asJsonNode());
    }

    private BigInteger getBigInteger(String path, String format, JsonNode node) {
        int precision;
        BigInteger maxAllowed;
        Matcher matcher;
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        String requiredType = "a biginteger";
        if (!this.isBigInteger(node)) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a biginteger"));
        }
        JsonRepresentation.checkValue(path, node, "a biginteger");
        BigInteger bigInteger = this.getBigInteger(path, node);
        if (format != null && (matcher = FORMAT_BIG_INTEGER.matcher(format)).matches() && bigInteger.compareTo(maxAllowed = BigInteger.TEN.pow(precision = Integer.parseInt(matcher.group(1)))) > 0) {
            throw new IllegalArgumentException(String.format("Value '%s' larger than that allowed by format '%s'", bigInteger, format));
        }
        return bigInteger;
    }

    private BigInteger getBigInteger(String path, JsonNode node) {
        if (node.isBigInteger()) {
            return node.bigIntegerValue();
        }
        if (node.isTextual()) {
            return new BigInteger(node.textValue());
        }
        if (node.isLong()) {
            return BigInteger.valueOf(node.longValue());
        }
        if (node.isInt()) {
            return BigInteger.valueOf(node.intValue());
        }
        throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a biginteger, is not any other integral number, is not text parseable as a biginteger"));
    }

    public boolean isBigDecimal(String path) {
        return this.isBigDecimal(this.getNode(path));
    }

    public boolean isBigDecimal() {
        return this.isBigDecimal(this.asJsonNode());
    }

    private boolean isBigDecimal(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && (node.isBigDecimal() || node.isDouble() || node.isLong() || node.isInt() || node.isBigInteger() || node.isTextual() && JsonRepresentation.parseableAsBigDecimal(node.textValue()));
    }

    private static boolean parseableAsBigDecimal(String str) {
        try {
            new BigDecimal(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BigDecimal getBigDecimal(String path) {
        return this.getBigDecimal(path, (String)null);
    }

    public BigDecimal getBigDecimal(String path, String formatRequested) {
        String format;
        JsonNode node;
        if (formatRequested != null) {
            node = this.getNode(path);
            format = formatRequested;
        } else {
            NodeAndFormat nodeAndFormat = this.getNodeAndFormat(path);
            node = nodeAndFormat.node;
            format = nodeAndFormat.format;
        }
        return this.getBigDecimal(path, format, node);
    }

    public BigDecimal asBigDecimal() {
        return this.asBigDecimal(null);
    }

    public BigDecimal asBigDecimal(String format) {
        return this.getBigDecimal(null, format, this.asJsonNode());
    }

    private BigDecimal getBigDecimal(String path, String format, JsonNode node) {
        Matcher matcher;
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        String requiredType = "a bigdecimal";
        if (!this.isBigDecimal(node)) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a bigdecimal"));
        }
        JsonRepresentation.checkValue(path, node, "a bigdecimal");
        BigDecimal bigDecimal = this.getBigDecimal(path, node);
        if (format != null && (matcher = FORMAT_BIG_DECIMAL.matcher(format)).matches()) {
            int scale;
            int precision = Integer.parseInt(matcher.group(1));
            BigDecimal maxAllowed = BigDecimal.TEN.pow(precision - (scale = Integer.parseInt(matcher.group(2))));
            if (bigDecimal.compareTo(maxAllowed) > 0) {
                throw new IllegalArgumentException(String.format("Value '%s' larger than that allowed by format '%s'", bigDecimal, format));
            }
            return bigDecimal.setScale(scale, RoundingMode.HALF_EVEN);
        }
        return bigDecimal;
    }

    private BigDecimal getBigDecimal(String path, JsonNode node) {
        if (node.isBigDecimal()) {
            return node.decimalValue();
        }
        if (node.isTextual()) {
            return new BigDecimal(node.textValue());
        }
        if (node.isLong()) {
            return new BigDecimal(node.longValue());
        }
        if (node.isDouble()) {
            return BigDecimal.valueOf(node.doubleValue());
        }
        if (node.isBigInteger()) {
            return new BigDecimal(node.bigIntegerValue());
        }
        if (node.isInt()) {
            return new BigDecimal(node.intValue());
        }
        throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a bigdecimal, is not any other numeric, is not text parseable as a bigdecimal"));
    }

    public boolean isString(String path) {
        return this.isString(this.getNode(path));
    }

    public boolean isString() {
        return this.isString(this.asJsonNode());
    }

    private boolean isString(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isTextual();
    }

    public String getString(String path) {
        JsonNode node = this.getNode(path);
        return this.getString(path, node);
    }

    public String asString() {
        return this.getString(null, this.asJsonNode());
    }

    private String getString(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a string");
        if (!node.isTextual()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a string"));
        }
        return node.textValue();
    }

    public String asArg() {
        if (this.isValue()) {
            return this.asJsonNode().asText();
        }
        return this.asJsonNode().toString();
    }

    public boolean isLink() {
        return this.isLink(this.asJsonNode());
    }

    public boolean isLink(String path) {
        return this.isLink(this.getNode(path));
    }

    public boolean isLink(JsonNode node) {
        if (JsonRepresentation.representsNull(node) || this.isArray(node) || node.isValueNode()) {
            return false;
        }
        LinkRepresentation link = new LinkRepresentation(node);
        return link.getHref() != null;
    }

    public LinkRepresentation getLink(String path) {
        return this.getLink(path, this.getNode(path));
    }

    public LinkRepresentation asLink() {
        return this.getLink(null, this.asJsonNode());
    }

    private LinkRepresentation getLink(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        if (this.isArray(node)) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is an array that does not represent a link"));
        }
        if (node.isValueNode()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is a value that does not represent a link"));
        }
        LinkRepresentation link = new LinkRepresentation(node);
        if (link.getHref() == null) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is a map that does not fully represent a link"));
        }
        return link;
    }

    public boolean isNull() {
        return this.isNull(this.asJsonNode());
    }

    public Boolean isNull(String path) {
        return this.isNull(this.getNode(path));
    }

    private Boolean isNull(JsonNode node) {
        if (node == null || node.isMissingNode()) {
            return null;
        }
        return node.isNull();
    }

    public JsonRepresentation getNull(String path) {
        return this.getNull(path, this.getNode(path));
    }

    public JsonRepresentation asNull() {
        return this.getNull(null, this.asJsonNode());
    }

    private JsonRepresentation getNull(String path, JsonNode node) {
        if (node == null || node.isMissingNode()) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "the null value");
        if (!node.isNull()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not the null value"));
        }
        return new JsonRepresentation(node);
    }

    public LinkRepresentation mapValueAsLink() {
        if (this.asJsonNode().size() != 1) {
            throw new IllegalStateException("does not represent link");
        }
        String linkPropertyName = (String)this.asJsonNode().fieldNames().next();
        return this.getLink(linkPropertyName);
    }

    public InputStream asInputStream() {
        return JsonNodeUtils.asInputStream(this.jsonNode);
    }

    protected ArrayNode asArrayNode() {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        return (ArrayNode)this.asJsonNode();
    }

    protected ObjectNode asObjectNode() {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        return (ObjectNode)this.asJsonNode();
    }

    public <T extends JsonRepresentation> T as(Class<T> cls) {
        try {
            Constructor<T> constructor = cls.getConstructor(JsonNode.class);
            return (T)((JsonRepresentation)constructor.newInstance(this.jsonNode));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String asUrlEncoded() {
        return UrlEncodingUtils.urlEncode(this.asJsonNode());
    }

    public JsonRepresentation arrayAdd(Object value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add((JsonNode)new POJONode(value));
        return this;
    }

    public JsonRepresentation arrayAdd(JsonRepresentation value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value.asJsonNode());
        return this;
    }

    public JsonRepresentation arrayAdd(String value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
        return this;
    }

    public JsonRepresentation arrayAdd(JsonNode value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
        return this;
    }

    public JsonRepresentation arrayAdd(long value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
        return this;
    }

    public JsonRepresentation arrayAdd(int value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
        return this;
    }

    public JsonRepresentation arrayAdd(double value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
        return this;
    }

    public JsonRepresentation arrayAdd(float value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
        return this;
    }

    public JsonRepresentation arrayAdd(boolean value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
        return this;
    }

    public Stream<JsonRepresentation> streamArrayElements() {
        return this.streamArrayElements(JsonRepresentation.class);
    }

    public <T> Stream<T> streamArrayElements(Class<T> requiredType) {
        this.ensureIsAnArrayAtLeastAsLargeAs(0);
        Function<JsonNode, ?> transformer = JsonRepresentation.representationInstantiatorFor(requiredType);
        ArrayNode arrayNode = (ArrayNode)this.jsonNode;
        Iterator iterator = arrayNode.iterator();
        Function<JsonNode, T> typedTransformer = JsonRepresentation.asT(transformer);
        return _NullSafe.stream((Iterator)iterator).map(typedTransformer);
    }

    private static <T> Function<JsonNode, T> asT(Function<JsonNode, ?> transformer) {
        return transformer;
    }

    public JsonRepresentation arrayGet(int i) {
        this.ensureIsAnArrayAtLeastAsLargeAs(i + 1);
        return new JsonRepresentation(this.jsonNode.get(i));
    }

    public JsonRepresentation arraySetElementAt(int i, JsonRepresentation objectRepr) {
        this.ensureIsAnArrayAtLeastAsLargeAs(i + 1);
        if (objectRepr.isArray()) {
            throw new IllegalArgumentException("Representation being set cannot be an array");
        }
        ArrayNode arrayNode = (ArrayNode)this.jsonNode;
        arrayNode.set(i, objectRepr.asJsonNode());
        return this;
    }

    private void ensureIsAnArrayAtLeastAsLargeAs(int i) {
        if (!this.jsonNode.isArray()) {
            throw new IllegalStateException("Is not an array");
        }
        if (i > this.size()) {
            throw new IndexOutOfBoundsException("array has only " + this.size() + " elements");
        }
    }

    public boolean mapHas(String key) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        ObjectNode node = this.asObjectNode();
        String[] paths = key.split("\\.");
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            boolean has = node.has(path);
            if (!has) {
                return false;
            }
            if (i + 1 >= paths.length) continue;
            JsonNode subNode = node.get(path);
            if (!subNode.isObject()) {
                return false;
            }
            node = (ObjectNode)subNode;
        }
        return true;
    }

    public JsonRepresentation mapPut(String key, List<Object> value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        if (value == null) {
            return this;
        }
        JsonRepresentation array = JsonRepresentation.newArray();
        for (Object v : value) {
            array.arrayAdd(v);
        }
        this.mapPutJsonRepresentation(key, array);
        return this;
    }

    public JsonRepresentation mapPut(String key, Object value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.set(path.getTail(), (JsonNode)(value != null ? new POJONode(value) : NullNode.getInstance()));
        return this;
    }

    public JsonRepresentation mapPutJsonRepresentation(String key, JsonRepresentation value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        if (value == null) {
            return this;
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.set(path.getTail(), value.asJsonNode());
        return this;
    }

    public JsonRepresentation mapPutString(String key, String value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        if (value == null) {
            return this;
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
        return this;
    }

    public JsonRepresentation mapPutJsonNode(String key, JsonNode value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        if (value == null) {
            return this;
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.set(path.getTail(), value);
        return this;
    }

    public JsonRepresentation mapPutByte(String key, byte value) {
        return this.mapPutInt(key, value);
    }

    public JsonRepresentation mapPutByteNullable(String key, Byte value) {
        return value != null ? this.mapPutByte(key, value) : this.mapPut(key, value);
    }

    public JsonRepresentation mapPutShort(String key, short value) {
        return this.mapPutInt(key, value);
    }

    public JsonRepresentation mapPutShortNullable(String key, Short value) {
        return value != null ? this.mapPutShort(key, value) : this.mapPut(key, value);
    }

    public JsonRepresentation mapPutInt(String key, int value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
        return this;
    }

    public JsonRepresentation mapPutIntNullable(String key, Integer value) {
        return value != null ? this.mapPutInt(key, value) : this.mapPut(key, value);
    }

    public JsonRepresentation mapPutLong(String key, long value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
        return this;
    }

    public JsonRepresentation mapPutLongNullable(String key, Long value) {
        return value != null ? this.mapPutLong(key, value) : this.mapPut(key, value);
    }

    public JsonRepresentation mapPutFloat(String key, float value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
        return this;
    }

    public JsonRepresentation mapPutFloatNullable(String key, Float value) {
        return value != null ? this.mapPutFloat(key, value.floatValue()) : this.mapPut(key, value);
    }

    public JsonRepresentation mapPutDouble(String key, double value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
        return this;
    }

    public JsonRepresentation mapPutDoubleNullable(String key, Double value) {
        return value != null ? this.mapPutDouble(key, value) : this.mapPut(key, value);
    }

    public JsonRepresentation mapPutBoolean(String key, boolean value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
        return this;
    }

    public JsonRepresentation mapPutBooleanNullable(String key, Boolean value) {
        return value != null ? this.mapPutBoolean(key, value) : this.mapPut(key, value);
    }

    public JsonRepresentation mapPutChar(String key, char value) {
        return this.mapPutString(key, "" + value);
    }

    public JsonRepresentation mapPutCharNullable(String key, Character value) {
        return value != null ? this.mapPutChar(key, value.charValue()) : this.mapPut(key, value);
    }

    public JsonRepresentation mapPutBigInteger(String key, BigInteger value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        if (value != null) {
            node.put(path.getTail(), value.toString());
        } else {
            node.set(path.getTail(), (JsonNode)NullNode.getInstance());
        }
        return this;
    }

    public JsonRepresentation mapPutEntries(Iterable<Map.Entry<String, JsonRepresentation>> entries) {
        for (Map.Entry<String, JsonRepresentation> entry : entries) {
            this.mapPutEntry(entry);
        }
        return this;
    }

    public JsonRepresentation mapPutEntry(Map.Entry<String, JsonRepresentation> entry) {
        this.mapPutJsonRepresentation(entry.getKey(), entry.getValue());
        return this;
    }

    public JsonRepresentation mapPutBigDecimal(String key, BigDecimal value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        if (value != null) {
            node.put(path.getTail(), value.toString());
        } else {
            node.set(path.getTail(), (JsonNode)NullNode.getInstance());
        }
        return this;
    }

    public JsonRepresentation putFormat(@Nullable String format) {
        if (format != null) {
            this.mapPutString("format", format);
        }
        return this;
    }

    public JsonRepresentation putExtendedFormat(@Nullable String format) {
        if (format != null) {
            this.mapPutString("extensions.x-causeway-format", format);
        }
        return this;
    }

    public Stream<Map.Entry<String, JsonRepresentation>> streamMapEntries() {
        this.ensureIsAMap();
        return _NullSafe.stream((Iterator)this.jsonNode.fields()).map(MAP_ENTRY_JSON_NODE_TO_JSON_REPRESENTATION);
    }

    private void ensureIsAMap() {
        if (!this.jsonNode.isObject()) {
            throw new IllegalStateException("Is not a map");
        }
    }

    public JsonRepresentation ensureArray() {
        if (this.jsonNode.isArray()) {
            return this;
        }
        JsonRepresentation arrayRepr = JsonRepresentation.newArray();
        arrayRepr.arrayAdd(this.jsonNode);
        return arrayRepr;
    }

    private JsonNode getNode(String path) {
        return this.getNodeAndFormat((String)path).node;
    }

    private NodeAndFormat getNodeAndFormat(String path) {
        JsonNode jsonNode = this.jsonNode;
        List<String> keys = PathNode.split(path);
        String format = null;
        for (String key : keys) {
            PathNode pathNode = PathNode.parse(key);
            if (!pathNode.getKey().isEmpty()) {
                format = this.getFormatValueIfAnyFrom(jsonNode);
                jsonNode = jsonNode.path(pathNode.getKey());
            }
            if (jsonNode.isNull()) {
                return new NodeAndFormat(jsonNode, format);
            }
            if (!pathNode.hasCriteria()) continue;
            if (!jsonNode.isArray()) {
                return new NodeAndFormat((JsonNode)NullNode.getInstance(), format);
            }
            format = this.getFormatValueIfAnyFrom(jsonNode);
            if (!(jsonNode = this.matching(jsonNode, pathNode)).isNull()) continue;
            return new NodeAndFormat(jsonNode, format);
        }
        return new NodeAndFormat(jsonNode, format);
    }

    private String getFormatValueIfAnyFrom(JsonNode jsonNode) {
        JsonNode formatNode = jsonNode.get("format");
        String format = formatNode != null && formatNode.isTextual() ? formatNode.textValue() : null;
        return format;
    }

    private JsonNode matching(JsonNode jsonNode, PathNode pathNode) {
        JsonRepresentation asList = new JsonRepresentation(jsonNode);
        List<JsonNode> matching = asList.streamArrayElements(JsonNode.class).filter(input -> pathNode.matches(new JsonRepresentation((JsonNode)input))).collect(Collectors.toList());
        return JsonRepresentation.toJsonNode(matching);
    }

    private static JsonNode toJsonNode(List<JsonNode> matching) {
        switch (matching.size()) {
            case 0: {
                return NullNode.getInstance();
            }
            case 1: {
                return matching.get(0);
            }
        }
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        arrayNode.addAll(matching);
        return arrayNode;
    }

    private static void checkValue(String path, JsonNode node, String requiredType) {
        if (node.isValueNode()) {
            return;
        }
        throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not " + requiredType));
    }

    private static boolean representsNull(JsonNode node) {
        return node == null || node.isMissingNode() || node.isNull();
    }

    private static String formatExMsg(String pathIfAny, String errorText) {
        StringBuilder buf = new StringBuilder();
        if (pathIfAny != null) {
            buf.append("'").append(pathIfAny).append("' ");
        }
        buf.append(errorText);
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jsonNode == null ? 0 : this.jsonNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonRepresentation other = (JsonRepresentation)obj;
        return !(this.jsonNode == null ? other.jsonNode != null : !this.jsonNode.equals((Object)other.jsonNode));
    }

    public String toString() {
        return this.jsonNode.toString();
    }

    static {
        REPRESENTATION_INSTANTIATORS.put(String.class, input -> {
            if (!input.isTextual()) {
                throw new IllegalStateException("found node that is not a string " + input.toString());
            }
            return input.textValue();
        });
        REPRESENTATION_INSTANTIATORS.put(JsonNode.class, input -> input);
        yyyyMMdd = ISODateTimeFormat.date().withZoneUTC();
        yyyyMMddTHHmmssZ = ISODateTimeFormat.dateTimeNoMillis().withZoneUTC();
        _HHmmss = ISODateTimeFormat.timeNoMillis().withZoneUTC();
        MAP_ENTRY_JSON_NODE_TO_JSON_REPRESENTATION = input -> new Map.Entry<String, JsonRepresentation>(){

            @Override
            public String getKey() {
                return (String)input.getKey();
            }

            @Override
            public JsonRepresentation getValue() {
                return new JsonRepresentation((JsonNode)input.getValue());
            }

            @Override
            public JsonRepresentation setValue(JsonRepresentation value) {
                JsonNode setValue = input.setValue(value.asJsonNode());
                return new JsonRepresentation(setValue);
            }
        };
    }

    private static class NodeAndFormat {
        JsonNode node;
        String format;

        NodeAndFormat(JsonNode jsonNode, String format) {
            this.node = jsonNode;
            this.format = format;
        }
    }

    private static class Path {
        private final List<String> head;
        private final String tail;

        private Path(List<String> head, String tail) {
            this.head = Collections.unmodifiableList(head);
            this.tail = tail;
        }

        public List<String> getHead() {
            return this.head;
        }

        public String getTail() {
            return this.tail;
        }

        public static Path parse(String pathStr) {
            ArrayList<String> keyList = new ArrayList<String>(Arrays.asList(pathStr.split("\\.")));
            if (keyList.size() == 0) {
                throw new IllegalArgumentException(String.format("Malformed path '%s'", pathStr));
            }
            String tail = (String)keyList.remove(keyList.size() - 1);
            return new Path(keyList, tail);
        }
    }

    public static interface HasExtensions {
        public JsonRepresentation getExtensions();
    }

    public static interface HasLinks {
        public JsonRepresentation getLinks();
    }

    public static interface HasLinkToUp {
        public LinkRepresentation getUp();
    }

    public static interface HasLinkToSelf {
        public LinkRepresentation getSelf();
    }
}

