/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.applib.domainobjects;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;

@Path(value="/objects")
public interface DomainObjectResource {
    @POST
    @Path(value="/{domainType}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response persist(@PathParam(value="domainType") String var1, InputStream var2);

    @GET
    @Path(value="/{domainType}/{instanceId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response object(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2);

    @PUT
    @Path(value="/{domainType}/{instanceId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response object(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, InputStream var3);

    @DELETE
    @Path(value="/{domainType}/{instanceId}")
    public Response deleteMethodNotSupported(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2);

    @POST
    @Path(value="/{domainType}/{instanceId}")
    public Response postMethodNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2);

    @GET
    @Path(value="/{domainType}/{instanceId}/image")
    @Consumes(value={"*/*"})
    @Produces(value={"image/png"})
    public Response image(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2);

    @GET
    @Path(value="/{domainType}/{instanceId}/object-layout")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-layout-bs\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-layout-bs\""})
    public Response layout(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2);

    @GET
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response propertyDetails(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="propertyId") String var3);

    @PUT
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response modifyProperty(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="propertyId") String var3, InputStream var4);

    @DELETE
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response clearProperty(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="propertyId") String var3);

    @POST
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    public Response postPropertyNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="propertyId") String var3);

    @GET
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-collection\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-collection\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response accessCollection(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="collectionId") String var3);

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-action\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response actionPrompt(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3);

    @DELETE
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    public Response deleteActionPromptNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3);

    @PUT
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    public Response putActionPromptNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3);

    @POST
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    public Response postActionPromptNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3);

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeActionQueryOnly(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3, @QueryParam(value="x-causeway-querystring") String var4);

    @PUT
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeActionIdempotent(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3, InputStream var4);

    @POST
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeAction(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3, InputStream var4);

    @DELETE
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    public Response deleteInvokeActionNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3);
}

