/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedCollection;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.causeway.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.ro.RepresentationService")
@Priority(value=0x1FFFFFFF)
public class RepresentationService {
    @Generated
    private static final Logger log = LogManager.getLogger(RepresentationService.class);
    private final List<ContentNegotiationService> contentNegotiationServices;

    @Inject
    public RepresentationService(List<ContentNegotiationService> contentNegotiationServices) {
        this.contentNegotiationServices = contentNegotiationServices;
    }

    public Response objectRepresentation(IResourceContext resourceContext, ManagedObject objectAdapter) {
        Response.ResponseBuilder responseBuilder = this.buildResponse((ContentNegotiationService connegService) -> connegService.buildResponse(resourceContext, objectAdapter));
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    public Response propertyDetails(IResourceContext resourceContext, ManagedProperty objectAndProperty) {
        Response.ResponseBuilder responseBuilder = this.buildResponse((ContentNegotiationService connegService) -> connegService.buildResponse(resourceContext, objectAndProperty));
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    public Response collectionDetails(IResourceContext resourceContext, ManagedCollection objectAndCollection) {
        Response.ResponseBuilder responseBuilder = this.buildResponse((ContentNegotiationService connegService) -> connegService.buildResponse(resourceContext, objectAndCollection));
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    public Response actionPrompt(IResourceContext resourceContext, ManagedAction objectAndAction) {
        Response.ResponseBuilder responseBuilder = this.buildResponse((ContentNegotiationService connegService) -> connegService.buildResponse(resourceContext, objectAndAction));
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    public Response actionResult(IResourceContext resourceContext, ObjectAndActionInvocation objectAndActionInvocation) {
        Response.ResponseBuilder responseBuilder = this.buildResponse((ContentNegotiationService connegService) -> connegService.buildResponse(resourceContext, objectAndActionInvocation));
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    void assertContentNegotiationServiceHandled(Response.ResponseBuilder responseBuilder) {
        if (responseBuilder == null) {
            throw new IllegalStateException("Could not locate " + ContentNegotiationService.class.getSimpleName() + " to handle request");
        }
    }

    Response.ResponseBuilder buildResponse(Function<ContentNegotiationService, Response.ResponseBuilder> connegServiceBuildResponse) {
        log.debug("ContentNegotiationServices:\n{}", new Supplier[]{() -> this.contentNegotiationServices.stream().map(Object::getClass).map(Class::getSimpleName).map(s -> " - " + s).collect(Collectors.joining("\n"))});
        for (ContentNegotiationService contentNegotiationService : this.contentNegotiationServices) {
            Response.ResponseBuilder responseBuilder = connegServiceBuildResponse.apply(contentNegotiationService);
            if (responseBuilder == null) continue;
            log.debug("--> winner: {}", new Supplier[]{() -> contentNegotiationService.getClass().getSimpleName()});
            return responseBuilder;
        }
        return null;
    }

    protected Response buildResponse(Response.ResponseBuilder responseBuilder) {
        return responseBuilder.build();
    }

    public static enum Intent {
        JUST_CREATED,
        ALREADY_PERSISTENT,
        NOT_APPLICABLE;

    }
}

