/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.conneg;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.factory._InstanceUtil;
import org.apache.causeway.commons.internal.reflection._ClassCache;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedCollection;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.causeway.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationService;

public abstract class ContentNegotiationServiceAbstract
implements ContentNegotiationService {
    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedObject objectAdapter) {
        return null;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedProperty objectAndProperty) {
        return null;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedCollection objectAndCollection) {
        return null;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedAction objectAndAction) {
        return null;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ObjectAndActionInvocation objectAndActionInvocation) {
        return null;
    }

    protected Object objectOf(ManagedObject objectAdapter) {
        return objectAdapter.getPojo();
    }

    protected Object returnedObjectOf(ObjectAndActionInvocation objectAndActionInvocation) {
        ManagedObject returnedAdapter = objectAndActionInvocation.getReturnedAdapter();
        return this.objectOf(returnedAdapter);
    }

    protected Class<?> loadClass(String cls) {
        Class domainType;
        try {
            domainType = _InstanceUtil.loadClass((String)cls);
        }
        catch (Exception ex) {
            throw RestfulObjectsApplicationException.createWithCause(RestfulResponse.HttpStatusCode.BAD_REQUEST, ex);
        }
        return domainType;
    }

    protected void ensureJaxbAnnotated(Class<?> domainType) {
        if (!_ClassCache.getInstance().hasJaxbRootElementSemantics(domainType)) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "Requested domain Type '" + domainType.getName() + "' is not annotated with JAXB @XmlRootElement annotation", new Object[0]);
        }
    }

    protected void ensureDomainObjectAssignable(String xRoDomainType, Class<?> domainType, Object domainObject) {
        if (!domainType.isAssignableFrom(domainObject.getClass())) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.NOT_ACCEPTABLE, "Requested object of type '%s' however the object returned by the domain object is not assignable (is '%s')", xRoDomainType, domainObject.getClass().getName());
        }
    }

    protected boolean mediaTypeParameterMatches(List<MediaType> acceptableMediaTypes, String parameter, String parameterValue) {
        for (MediaType mediaType : acceptableMediaTypes) {
            String paramValue = this.sanitize((String)mediaType.getParameters().get(parameter));
            if (!Objects.equals(paramValue, parameterValue)) continue;
            return true;
        }
        return false;
    }

    protected List<String> mediaTypeParameterList(List<MediaType> acceptableMediaTypes, String parameter) {
        ArrayList paramList = _Lists.newArrayList();
        for (MediaType mediaType : acceptableMediaTypes) {
            String paramValue = this.sanitize((String)mediaType.getParameters().get(parameter));
            _Strings.splitThenStream((String)paramValue, (String)",").map(String::trim).forEach(paramList::add);
        }
        return paramList;
    }

    private String sanitize(String mediaParam) {
        if (mediaParam == null) {
            return null;
        }
        if ((mediaParam = mediaParam.trim()).startsWith("'")) {
            mediaParam = mediaParam.substring(1);
        }
        if (mediaParam.endsWith("'")) {
            mediaParam = mediaParam.substring(0, mediaParam.length() - 1);
        }
        return mediaParam;
    }
}

