/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domainobjects;

import java.util.ArrayList;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.core.metamodel.facets.collections.CollectionFacet;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedCollection;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedMember;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.CollectionSemantics;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.CollectionDescriptionReprRenderer;

public class ObjectCollectionReprRenderer
extends AbstractObjectMemberReprRenderer<OneToManyAssociation> {
    public ObjectCollectionReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollowSpecs, String collectionId, JsonRepresentation representation) {
        super(resourceContext, linkFollowSpecs, collectionId, RepresentationType.OBJECT_COLLECTION, representation, Where.PARENTED_TABLES);
    }

    @Override
    public JsonRepresentation render() {
        boolean eagerlyRender;
        if (this.representation == null) {
            return null;
        }
        this.renderMemberContent();
        LinkFollowSpecs followValue = this.getLinkFollowSpecs().follow("value", new Object[0]);
        boolean bl = eagerlyRender = !followValue.isTerminated() || this.resourceContext.config().isHonorUiHints() && Facets.defaultViewIsTable((ObjectFeature)this.objectMember);
        if (this.mode.isInline() && eagerlyRender || this.mode.isStandalone() || this.mode.isMutated() || this.mode.isEventSerialization() || !ManagedObjects.isIdentifiable((ManagedObject)this.objectAdapter)) {
            this.addValue(followValue);
        }
        if (!this.mode.isEventSerialization()) {
            this.putDisabledReasonIfDisabled();
        }
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addExtensionsCausewayProprietaryChangedObjects();
        }
        return this.representation;
    }

    private void addValue(LinkFollowSpecs linkFollower) {
        ManagedObject valueAdapter = ((OneToManyAssociation)this.objectMember).get(this.objectAdapter, this.getInteractionInitiatedBy());
        if (valueAdapter == null) {
            return;
        }
        LinkFollowSpecs followHref = linkFollower.follow("href", new Object[0]);
        boolean eagerlyRender = !followHref.isTerminated() || this.resourceContext.config().isHonorUiHints() && Facets.defaultViewIsTable((ObjectFeature)this.objectMember) && this.resourceContext.canEagerlyRender(valueAdapter);
        ArrayList list = _Lists.newArrayList();
        CollectionFacet.streamAdapters((ManagedObject)valueAdapter).forEach(elementAdapter -> {
            LinkBuilder valueLinkBuilder = DomainObjectReprRenderer.newLinkToBuilder(this.resourceContext, Rel.VALUE, elementAdapter);
            if (eagerlyRender) {
                DomainObjectReprRenderer domainObjectReprRenderer = new DomainObjectReprRenderer(this.getResourceContext(), followHref, JsonRepresentation.newMap((String[])new String[0])).with((ManagedObject)elementAdapter);
                if (this.mode.isEventSerialization()) {
                    domainObjectReprRenderer.asEventSerialization();
                }
                valueLinkBuilder.withValue(domainObjectReprRenderer.render());
            }
            list.add(valueLinkBuilder.build());
        });
        this.representation.mapPut("value", (Object)list);
    }

    @Override
    protected void followDetailsLink(JsonRepresentation detailsLink) {
        Where where = this.resourceContext.getWhere();
        JsonRepresentation jsonRepresentation = JsonRepresentation.newMap((String[])new String[0]);
        AbstractObjectMemberReprRenderer objectCollectionReprRenderer = new ObjectCollectionReprRenderer(this.getResourceContext(), this.getLinkFollowSpecs(), null, jsonRepresentation).with((ManagedMember)ManagedCollection.of((ManagedObject)this.objectAdapter, (OneToManyAssociation)((OneToManyAssociation)this.objectMember), (Where)where)).asFollowed();
        detailsLink.mapPutJsonRepresentation("value", objectCollectionReprRenderer.render());
    }

    @Override
    protected void addMutatorLinksIfEnabled() {
    }

    @Override
    protected void addLinksToFormalDomainModel() {
        if (this.resourceContext.config().isSuppressDescribedByLinks()) {
            return;
        }
        JsonRepresentation link = CollectionDescriptionReprRenderer.newLinkToBuilder(this.resourceContext, Rel.DESCRIBEDBY, this.objectAdapter.objSpec(), (OneToManyAssociation)this.objectMember).build();
        this.getLinks().arrayAdd(link);
    }

    @Override
    protected void putExtensionsCausewayProprietary() {
        CollectionSemantics semantics = CollectionSemantics.valueOf((OneToManyAssociation)this.objectMember);
        this.getExtensions().mapPutString("collectionSemantics", semantics.name().toLowerCase());
    }
}

