/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domaintypes;

import java.util.Optional;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.AbstractTypeMemberReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.ActionParameterDescriptionReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;

public class ActionDescriptionReprRenderer
extends AbstractTypeMemberReprRenderer<ObjectAction> {
    public static LinkBuilder newLinkToBuilder(IResourceContext resourceContext, Rel rel, ObjectSpecification objectSpecification, ObjectAction objectAction) {
        String domainType = objectSpecification.logicalTypeName();
        String actionId = objectAction.getId();
        String url = "domain-types/" + domainType + "/actions/" + actionId;
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.ACTION_DESCRIPTION, url, new Object[0]);
    }

    public ActionDescriptionReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.ACTION_DESCRIPTION, representation);
    }

    @Override
    protected void addLinksSpecificToFeature() {
        this.addParameters();
        this.addLinkToReturnTypeIfAny();
        this.addLinkToElementTypeIfAny();
    }

    @Override
    protected void putExtensionsSpecificToFeature() {
        this.putExtensionsName();
        this.putExtensionsDescriptionIfAvailable();
    }

    private void addParameters() {
        JsonRepresentation parameterList = JsonRepresentation.newArray();
        Can parameters = ((ObjectAction)this.getObjectFeature()).getParameters();
        for (ObjectActionParameter parameter : parameters) {
            parameterList.arrayAdd(ActionParameterDescriptionReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.ACTION_PARAM, this.objectSpecification, parameter).build());
        }
        this.representation.mapPutJsonRepresentation("parameters", parameterList);
    }

    private void addLinkToElementTypeIfAny() {
        Optional.ofNullable(((ObjectAction)this.getObjectFeature()).getElementType()).ifPresent(typeOfSpec -> this.getLinks().arrayAdd(DomainTypeReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.ELEMENT_TYPE, typeOfSpec).build()));
    }

    private void addLinkToReturnTypeIfAny() {
        ObjectSpecification returnTypeSpec = ((ObjectAction)this.getObjectFeature()).getReturnType();
        if (returnTypeSpec == null) {
            return;
        }
        this.getLinks().arrayAdd(DomainTypeReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.RETURN_TYPE, returnTypeSpec).build());
    }
}

