/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.mappers.entity;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.List;
import java.util.stream.Stream;
import org.apache.causeway.applib.services.exceprecog.RootCauseFinder;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

@XmlRootElement(name="exceptionDetail")
@XmlType(name="exceptionDetail", propOrder={"className", "message", "stackTrace", "causedBy"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExceptionDetail {
    private String className;
    private String message;
    @XmlElementWrapper
    @XmlElement(name="element")
    private List<String> stackTrace = _Lists.newArrayList();
    private ExceptionDetail causedBy;

    public ExceptionDetail(Throwable ex, @Nullable List<RootCauseFinder> rootCauseFinders) {
        this.className = ex.getClass().getName();
        this.message = ex.getMessage();
        Stream.of(ex.getStackTrace()).map(ExceptionDetail::format).forEach(this.stackTrace::add);
        this.causedBy = _Exceptions.getRootCause((Throwable)ex, rootCauseFinders).filter(cause -> cause != ex).map(cause -> new ExceptionDetail((Throwable)cause, rootCauseFinders)).orElse(null);
    }

    private static String format(StackTraceElement stackTraceElement) {
        return stackTraceElement.toString();
    }

    public ExceptionDetail() {
    }

    public String getClassName() {
        return this.className;
    }

    public String getMessage() {
        return this.message;
    }

    public ExceptionDetail getCausedBy() {
        return this.causedBy;
    }
}

