/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.causeway.viewer.restfulobjects.rendering.service.valuerender.JsonValueEncoderService;
import org.apache.causeway.viewer.restfulobjects.rendering.util.RequestParams;

public class JsonParserHelper {
    private static final Pattern OBJECT_OID = Pattern.compile(".*objects\\/([^/]+)\\/(.+)");
    private final IResourceContext resourceContext;
    private final ObjectSpecification objectSpec;
    private final JsonValueEncoderService jsonValueEncoder;

    public JsonParserHelper(IResourceContext resourceContext, ObjectSpecification objectSpecification) {
        this.objectSpec = objectSpecification;
        this.resourceContext = resourceContext;
        this.jsonValueEncoder = (JsonValueEncoderService)resourceContext.getMetaModelContext().getServiceRegistry().lookupServiceElseFail(JsonValueEncoderService.class);
    }

    ManagedObject parseAsMapWithSingleValue(RequestParams body) {
        JsonRepresentation arguments = body.asMap();
        return this.parseAsMapWithSingleValue(arguments);
    }

    ManagedObject parseAsMapWithSingleValue(JsonRepresentation arguments) {
        JsonRepresentation representation = arguments.getRepresentation("value", new Object[0]);
        if (arguments.size() != 1 || representation == null) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Body should be a map with a single key 'value' whose value represents an instance of type '%s'", (Object[])new Object[]{JsonParserHelper.resourceFor(this.objectSpec)});
        }
        return this.objectAdapterFor(arguments);
    }

    ManagedObject objectAdapterFor(JsonRepresentation argRepr) {
        if (argRepr == null) {
            return null;
        }
        if (!argRepr.mapHas("value")) {
            String reason = "No 'value' key";
            argRepr.mapPutString("invalidReason", reason);
            throw new IllegalArgumentException(reason);
        }
        if (this.objectSpec == null) {
            String reason = "ObjectSpec is null, cannot validate";
            argRepr.mapPutString("invalidReason", reason);
            throw new IllegalArgumentException(reason);
        }
        JsonRepresentation argValueRepr = argRepr.getRepresentation("value", new Object[0]);
        if (this.objectSpec.isValue()) {
            try {
                return this.jsonValueEncoder.asAdapter(this.objectSpec, argValueRepr, null);
            }
            catch (IllegalArgumentException ex) {
                argRepr.mapPutString("invalidReason", ex.getMessage());
                throw ex;
            }
            catch (Exception ex) {
                StringBuilder buf = new StringBuilder("Failed to parse representation ");
                try {
                    String reprStr = argRepr.getString("value");
                    buf.append("'").append(reprStr).append("' ");
                }
                catch (Exception reprStr) {
                    // empty catch block
                }
                buf.append("as value of type '").append(this.objectSpec.getShortIdentifier()).append("'");
                String reason = buf.toString();
                argRepr.mapPutString("invalidReason", reason);
                throw new IllegalArgumentException(reason);
            }
        }
        if (!argValueRepr.isLink()) {
            String reason = "Expected a link (because this object's type is not a value) but found no 'href'";
            argRepr.mapPutString("invalidReason", "Expected a link (because this object's type is not a value) but found no 'href'");
            throw new IllegalArgumentException("Expected a link (because this object's type is not a value) but found no 'href'");
        }
        String oidFromHref = JsonParserHelper.encodedOidFromLink(argValueRepr);
        if (oidFromHref == null) {
            String reason = "Could not parse 'href' to identify the object's OID";
            argRepr.mapPutString("invalidReason", "Could not parse 'href' to identify the object's OID");
            throw new IllegalArgumentException("Could not parse 'href' to identify the object's OID");
        }
        ManagedObject objectAdapter = (ManagedObject)this.resourceContext.getObjectAdapterForOidFromHref(oidFromHref).orElseThrow(() -> {
            String reason = "'href' does not reference a known entity";
            argRepr.mapPutString("invalidReason", "'href' does not reference a known entity");
            return new IllegalArgumentException("'href' does not reference a known entity");
        });
        return objectAdapter;
    }

    static String encodedOidFromLink(JsonRepresentation link) {
        String href = link.getString("href");
        Matcher matcher = OBJECT_OID.matcher(href);
        if (!matcher.matches()) {
            return null;
        }
        String domainType = matcher.group(1);
        String instanceId = matcher.group(2);
        return Bookmark.forLogicalTypeNameAndIdentifier((String)domainType, (String)instanceId).stringify();
    }

    private static String resourceFor(ObjectSpecification objectSpec) {
        return objectSpec.getFullIdentifier();
    }
}

