/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.webmodule.auth;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.security.authentication.manager.AuthenticationManager;
import org.apache.causeway.viewer.restfulobjects.viewer.webmodule.auth.AuthenticationStrategy;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class AuthenticationStrategyAbstract
implements AuthenticationStrategy {
    public static final int STATUS_UNAUTHORIZED = 401;
    private AuthenticationManager authenticationManager;

    protected AuthenticationManager getAuthenticationManager(ServletRequest servletRequest) {
        if (this.authenticationManager == null) {
            ServletContext servletContext = this.getServletContext(servletRequest);
            WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            if (webApplicationContext == null) {
                throw _Exceptions.illegalState((String)"Requires a WebApplicationContext (Spring).", (Object[])new Object[0]);
            }
            this.authenticationManager = (AuthenticationManager)webApplicationContext.getBean(AuthenticationManager.class);
        }
        return this.authenticationManager;
    }

    protected HttpSession getHttpSession(ServletRequest servletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        return httpServletRequest.getSession();
    }

    protected ServletContext getServletContext(ServletRequest servletRequest) {
        return servletRequest.getServletContext();
    }

    @Override
    public final void invalidate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.bind(httpServletRequest, httpServletResponse, null);
        httpServletResponse.setStatus(401);
    }
}

