/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import jakarta.inject.Inject;
import java.util.stream.Stream;
import org.apache.causeway.applib.services.iactnlayer.InteractionContext;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.commons.applib.services.branding.BrandingUiService;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.DomainServiceLinkTo;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ListReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.TypeListReprRenderer;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.UserReprRenderer;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.VersionReprRenderer;

public class HomePageReprRenderer
extends ReprRendererAbstract<Void> {
    @Inject
    BrandingUiService brandingUiService;

    HomePageReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.HOME_PAGE, representation);
        resourceContext.getMetaModelContext().getServiceInjector().injectServicesInto((Object)this);
    }

    public HomePageReprRenderer with(Void t) {
        return this;
    }

    public JsonRepresentation render() {
        if (this.includesSelf) {
            this.addLinkToSelf();
        }
        MetaModelContext metaModelContext = super.getResourceContext().getMetaModelContext();
        this.addLinkToUser(this.getResourceContext().getInteractionService().currentInteractionContextElseFail());
        this.addLinksToApplicationLogos();
        this.addLinkToMenuBars();
        this.addLinkToServices(metaModelContext.streamServiceAdapters());
        this.addLinkToVersion();
        this.addLinkToDomainTypes((Can<? extends ObjectSpecification>)this.getResourceContext().getMetaModelContext().getSpecificationLoader().snapshotSpecifications());
        this.representation.mapPutJsonRepresentation("extensions", JsonRepresentation.newMap((String[])new String[0]));
        return this.representation;
    }

    private void addLinkToSelf() {
        JsonRepresentation link = LinkBuilder.newBuilder((IResourceContext)this.resourceContext, (String)Rel.SELF.getName(), (RepresentationType)RepresentationType.HOME_PAGE, (String)"", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            HomePageReprRenderer renderer = new HomePageReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            link.mapPutJsonRepresentation("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToVersion() {
        JsonRepresentation link = LinkBuilder.newBuilder((IResourceContext)this.getResourceContext(), (String)Rel.VERSION.getName(), (RepresentationType)RepresentationType.VERSION, (String)"version", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            VersionReprRenderer renderer = new VersionReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            link.mapPutJsonRepresentation("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToServices(Stream<ManagedObject> serviceAdapters) {
        JsonRepresentation link = LinkBuilder.newBuilder((IResourceContext)this.getResourceContext(), (String)Rel.SERVICES.getName(), (RepresentationType)RepresentationType.LIST, (String)"services", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollowSpecs = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollowSpecs.matches(link)) {
            ListReprRenderer renderer = new ListReprRenderer(this.getResourceContext(), linkFollowSpecs, JsonRepresentation.newMap((String[])new String[0]));
            renderer.usingLinkToBuilder((ObjectAdapterLinkTo)new DomainServiceLinkTo()).withLink(Rel.SELF, "services").with(serviceAdapters);
            link.mapPutJsonRepresentation("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToUser(InteractionContext authentication) {
        JsonRepresentation link = LinkBuilder.newBuilder((IResourceContext)this.getResourceContext(), (String)Rel.USER.getName(), (RepresentationType)RepresentationType.USER, (String)"user", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            UserReprRenderer renderer = new UserReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(authentication);
            link.mapPutJsonRepresentation("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinksToApplicationLogos() {
        this.brandingUiService.getSignInBranding().getLogoHref().ifPresent(href -> this.getLinks().arrayAdd(LinkBuilder.newBuilder((IResourceContext)this.getResourceContext(), (String)Rel.BRAND_LOGO_SIGNIN.getName(), (RepresentationType)RepresentationType.IMAGE, (String)href, (Object[])new Object[0]).buildAsApplicationResource()));
        this.brandingUiService.getHeaderBranding().getLogoHref().ifPresent(href -> this.getLinks().arrayAdd(LinkBuilder.newBuilder((IResourceContext)this.getResourceContext(), (String)Rel.BRAND_LOGO_HEADER.getName(), (RepresentationType)RepresentationType.IMAGE, (String)href, (Object[])new Object[0]).buildAsApplicationResource()));
    }

    private void addLinkToMenuBars() {
        JsonRepresentation link = LinkBuilder.newBuilder((IResourceContext)this.getResourceContext(), (String)Rel.MENUBARS.getName(), (RepresentationType)RepresentationType.MENUBARS, (String)"menuBars", (Object[])new Object[0]).build();
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToDomainTypes(Can<? extends ObjectSpecification> specifications) {
        JsonRepresentation link = LinkBuilder.newBuilder((IResourceContext)this.getResourceContext(), (String)Rel.DOMAIN_TYPES.getName(), (RepresentationType)RepresentationType.TYPE_LIST, (String)"domain-types", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            TypeListReprRenderer renderer = new TypeListReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.withLink(Rel.SELF, "domain-types").with(specifications);
            link.mapPutJsonRepresentation("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }
}

