/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import jakarta.ws.rs.core.Response;
import java.util.concurrent.atomic.LongAdder;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.id.LogicalType;
import org.apache.causeway.applib.services.registry.ServiceRegistry;
import org.apache.causeway.applib.services.xactn.TransactionService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Railway;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.interactions.managed.ActionInteraction;
import org.apache.causeway.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedCollection;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedMember;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.causeway.core.metamodel.interactions.managed.MemberInteraction;
import org.apache.causeway.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ActionResultReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.DomainObjectLinkTo;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.DomainServiceLinkTo;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.causeway.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.causeway.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.InteractionFailureHandler;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.ObjectActionArgHelper;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.ObjectAdapterAccessHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class _DomainResourceHelper {
    private final IResourceContext resourceContext;
    private final RepresentationService representationService;
    private final TransactionService transactionService;
    private final ManagedObject objectAdapter;

    public static _DomainResourceHelper ofObjectResource(IResourceContext resourceContext, ManagedObject objectAdapter) {
        return new _DomainResourceHelper(resourceContext, objectAdapter, (ObjectAdapterLinkTo)new DomainObjectLinkTo());
    }

    public static _DomainResourceHelper ofServiceResource(IResourceContext resourceContext, String serviceIdOrAlias) {
        return new _DomainResourceHelper(resourceContext, _DomainResourceHelper.getServiceAdapter(resourceContext, serviceIdOrAlias), (ObjectAdapterLinkTo)new DomainServiceLinkTo());
    }

    private _DomainResourceHelper(IResourceContext resourceContext, ManagedObject objectAdapter, ObjectAdapterLinkTo adapterLinkTo) {
        ((ResourceContext)resourceContext).setObjectAdapterLinkTo(adapterLinkTo);
        this.resourceContext = resourceContext;
        this.objectAdapter = objectAdapter;
        adapterLinkTo.usingUrlBase(this.resourceContext).with(this.objectAdapter);
        this.representationService = this.lookupService(RepresentationService.class);
        this.transactionService = this.lookupService(TransactionService.class);
    }

    public Response objectRepresentation() {
        this.transactionService.flushTransaction();
        return this.representationService.objectRepresentation(this.resourceContext, this.objectAdapter);
    }

    public Response propertyDetails(String propertyId, ManagedMember.RepresentationMode representationMode) {
        ManagedProperty property = ObjectAdapterAccessHelper.of(this.resourceContext, this.objectAdapter).getPropertyThatIsVisibleForIntent(propertyId, MemberInteraction.AccessIntent.ACCESS);
        property.setRepresentationMode(representationMode);
        this.transactionService.flushTransaction();
        return this.representationService.propertyDetails(this.resourceContext, property);
    }

    public Response collectionDetails(String collectionId, ManagedMember.RepresentationMode representationMode) {
        ManagedCollection collection = ObjectAdapterAccessHelper.of(this.resourceContext, this.objectAdapter).getCollectionThatIsVisibleForIntent(collectionId, MemberInteraction.AccessIntent.ACCESS);
        collection.setRepresentationMode(representationMode);
        this.transactionService.flushTransaction();
        return this.representationService.collectionDetails(this.resourceContext, collection);
    }

    public Response actionPrompt(String actionId) {
        ManagedAction action = ObjectAdapterAccessHelper.of(this.resourceContext, this.objectAdapter).getObjectActionThatIsVisibleForIntentAndSemanticConstraint(actionId, MemberInteraction.AccessIntent.ACCESS, ActionInteraction.SemanticConstraint.NONE);
        this.transactionService.flushTransaction();
        return this.representationService.actionPrompt(this.resourceContext, action);
    }

    public Response invokeActionQueryOnly(String actionId, JsonRepresentation arguments) {
        return this.invokeAction(actionId, MemberInteraction.AccessIntent.MUTATE, ActionInteraction.SemanticConstraint.SAFE, arguments, ActionResultReprRenderer.SelfLink.EXCLUDED);
    }

    public Response invokeActionIdempotent(String actionId, JsonRepresentation arguments) {
        return this.invokeAction(actionId, MemberInteraction.AccessIntent.MUTATE, ActionInteraction.SemanticConstraint.IDEMPOTENT, arguments, ActionResultReprRenderer.SelfLink.EXCLUDED);
    }

    public Response invokeAction(String actionId, JsonRepresentation arguments) {
        return this.invokeAction(actionId, MemberInteraction.AccessIntent.MUTATE, ActionInteraction.SemanticConstraint.NONE, arguments, ActionResultReprRenderer.SelfLink.EXCLUDED);
    }

    private Response invokeAction(@NonNull String actionId, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull MemberInteraction.AccessIntent intent, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ActionInteraction.SemanticConstraint semanticConstraint, @NonNull JsonRepresentation arguments, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ActionResultReprRenderer.SelfLink selfLink) {
        Consent actionConsent;
        boolean hasParams;
        Where where = this.resourceContext.getWhere();
        ActionInteraction actionInteraction = ((ActionInteraction)((ActionInteraction)ActionInteraction.start((ManagedObject)this.objectAdapter, (String)actionId, (Where)where).checkVisibility()).checkUsability(intent)).checkSemanticConstraint(semanticConstraint);
        ParameterNegotiationModel pendingArgs = actionInteraction.startParameterNegotiation().orElse(null);
        if (pendingArgs == null) {
            throw InteractionFailureHandler.onFailure(actionInteraction.getInteractionVeto().orElseGet(() -> InteractionVeto.notFound((Identifier.Type)Identifier.Type.ACTION, (String)actionId)));
        }
        boolean bl = hasParams = pendingArgs.getParamCount() > 0;
        if (hasParams) {
            LongAdder vetoCount = new LongAdder();
            Can<Railway<InteractionVeto, ManagedObject>> paramsOrVetos = ObjectActionArgHelper.parseArguments(this.resourceContext, pendingArgs.act(), arguments);
            pendingArgs.getParamModels().zip(paramsOrVetos, (managedParam, paramOrVeto) -> paramOrVeto.ifFailure(veto -> {
                InteractionFailureHandler.collectParameterInvalid(managedParam.getMetaModel(), veto, arguments);
                vetoCount.increment();
            }));
            if (vetoCount.intValue() > 0) {
                throw InteractionFailureHandler.onParameterListInvalid(InteractionVeto.actionParamInvalid((String)"error parsing arguments"), arguments);
            }
            Can argAdapters = paramsOrVetos.map(Railway::getSuccessElseFail);
            pendingArgs.setParamValues(argAdapters);
            Can individualParamConsents = pendingArgs.validateParameterSetForParameters();
            pendingArgs.getParamModels().zip((Iterable)individualParamConsents, (managedParam, consent) -> {
                if (consent.isVetoed()) {
                    InteractionVeto veto = InteractionVeto.actionParamInvalid((Consent)consent);
                    InteractionFailureHandler.collectParameterInvalid(managedParam.getMetaModel(), veto, arguments);
                    vetoCount.increment();
                }
            });
            if (vetoCount.intValue() > 0) {
                throw InteractionFailureHandler.onParameterListInvalid(InteractionVeto.actionParamInvalid((String)String.format("%d argument(s) failed validation", vetoCount.intValue())), arguments);
            }
        }
        if ((actionConsent = pendingArgs.validateParameterSetForAction()).isVetoed()) {
            throw InteractionFailureHandler.onParameterListInvalid(InteractionVeto.invalid((Consent)actionConsent), arguments);
        }
        if (this.resourceContext.isValidateOnly()) {
            return Response.noContent().build();
        }
        Railway resultOrVeto = actionInteraction.invokeWith(pendingArgs);
        resultOrVeto.ifFailure(veto -> {
            throw InteractionFailureHandler.onFailure(veto);
        });
        ActionInteraction.Result actionInteractionResult = new ActionInteraction.Result((ManagedAction)actionInteraction.getManagedAction().orElse(null), pendingArgs.getParamValues(), (ManagedObject)resultOrVeto.getSuccessElseFail());
        ObjectAndActionInvocation objectAndActionInvocation = ObjectAndActionInvocation.of((ActionInteraction.Result)actionInteractionResult, (JsonRepresentation)arguments, (ActionResultReprRenderer.SelfLink)selfLink);
        this.transactionService.flushTransaction();
        return this.representationService.actionResult(this.resourceContext, objectAndActionInvocation);
    }

    static ManagedObject getServiceAdapter(IResourceContext resourceContext, @Nullable String serviceIdOrAlias) {
        MetaModelContext mmc = resourceContext.getMetaModelContext();
        ManagedObject serviceAdapter = mmc.getSpecificationLoader().lookupLogicalType(serviceIdOrAlias).map(LogicalType::logicalName).map(arg_0 -> ((MetaModelContext)mmc).lookupServiceAdapterById(arg_0)).orElse(null);
        if (serviceAdapter == null) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND, (String)"Could not locate service '%s'", (Object[])new Object[]{serviceIdOrAlias});
        }
        return serviceAdapter;
    }

    private <T> T lookupService(Class<T> serviceType) {
        return (T)this.getServiceRegistry().lookupServiceElseFail(serviceType);
    }

    private ServiceRegistry getServiceRegistry() {
        return this.resourceContext.getMetaModelContext().getServiceRegistry();
    }
}

