/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.util.Objects;
import java.util.Optional;
import org.apache.causeway.applib.id.HasLogicalType;
import org.apache.causeway.applib.id.LogicalType;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.object.PackedManagedObject;
import org.apache.causeway.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.wicket.model.models.ModelAbstract;
import org.springframework.lang.Nullable;

public final class ManagedObjectModel
extends ModelAbstract<ManagedObject> {
    private final Object $lock = new Object[0];
    private static final long serialVersionUID = 1L;
    private ObjectMemento memento;
    private transient ObjectSpecification elementTypeSpec;
    private transient boolean isObjectSpecMemoized = false;

    protected ManagedObjectModel() {
        this(null);
    }

    protected ManagedObjectModel(@Nullable ObjectMemento initialMemento) {
        this.memento = initialMemento;
    }

    protected ManagedObject load() {
        if (this.memento == null) {
            return null;
        }
        return this.getObjectManager().demementify(this.memento);
    }

    public void setObject(ManagedObject adapter) {
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)adapter)) {
            super.setObject(null);
            this.memento = null;
            return;
        }
        super.setObject((Object)adapter);
        if (adapter instanceof PackedManagedObject) {
            this.setObjectCollection((PackedManagedObject)adapter);
        } else {
            this.memento = (ObjectMemento)adapter.getMemento().orElseThrow();
        }
    }

    public void setObjectCollection(PackedManagedObject adapter) {
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)adapter)) {
            super.setObject(null);
            this.memento = null;
            return;
        }
        super.setObject((Object)adapter);
        this.memento = (ObjectMemento)adapter.getMemento().orElseThrow();
    }

    public final Bookmark asBookmarkIfSupported() {
        return this.memento != null ? this.memento.getBookmark() : null;
    }

    public final String oidStringIfSupported() {
        return this.memento != null ? this.memento.toString() : null;
    }

    public Optional<LogicalType> getLogicalElementType() {
        return Optional.ofNullable(this.memento).map(HasLogicalType::getLogicalType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSpecification getTypeOfSpecification() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.isObjectSpecMemoized) {
                LogicalType logicalType = this.getLogicalElementType().orElse(null);
                this.elementTypeSpec = super.getSpecificationLoader().specForLogicalType(logicalType).orElse(null);
                this.isObjectSpecMemoized = true;
            }
            return this.elementTypeSpec;
        }
    }

    public boolean isEmpty() {
        return this.memento == null;
    }

    public final int hashCode() {
        return Objects.hashCode(this.memento);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ManagedObjectModel) {
            ManagedObjectModel other = (ManagedObjectModel)obj;
            return Objects.equals(this.memento, other.memento);
        }
        return false;
    }
}

