/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.util;

import java.io.Serializable;
import lombok.Generated;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.hint.HintStore;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.wicket.Component;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public class ComponentHintKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient HintStore hintStore;
    private final SerializableSupplier<Component> componentProvider;
    private Component component;
    private final String keyName;
    private final String fullKey;

    public static ComponentHintKey create(MetaModelContext commonContext, SerializableSupplier<Component> componentProvider, String key) {
        return new ComponentHintKey((HintStore)commonContext.lookupServiceElseFail(HintStore.class), componentProvider, null, key, null);
    }

    public static ComponentHintKey create(MetaModelContext commonContext, Component path, String key) {
        return new ComponentHintKey((HintStore)commonContext.lookupServiceElseFail(HintStore.class), null, path, key, null);
    }

    public static ComponentHintKey create(HintStore hintStore, String fullKey) {
        return new ComponentHintKey(hintStore, null, null, null, fullKey);
    }

    public String getKey() {
        return this.fullKey != null ? this.fullKey : this.keyFor(this.component != null ? this.component : (this.component = (Component)this.componentProvider.get()), this.keyName);
    }

    protected String keyFor(Component component, String keyName) {
        return UiHintContainer.Util.hintPathFor(component) + "-" + keyName;
    }

    public boolean matches(Component component, String keyName) {
        String key = this.getKey();
        String keyOfProvided = this.keyFor(component, keyName);
        return keyOfProvided.equals(key);
    }

    public void set(Bookmark bookmark, String value) {
        if (bookmark == null) {
            return;
        }
        if (value != null) {
            this.getHintStore().set(bookmark, this.getKey(), value);
        } else {
            this.remove(bookmark);
        }
    }

    public String get(Bookmark bookmark) {
        if (bookmark == null) {
            return null;
        }
        return this.getHintStore().get(bookmark, this.getKey());
    }

    public void remove(Bookmark bookmark) {
        if (bookmark == null) {
            return;
        }
        String key = this.getKey();
        this.getHintStore().remove(bookmark, key);
    }

    public void hintTo(Bookmark bookmark, PageParameters pageParameters, String prefix) {
        String value = this.get(bookmark);
        if (value == null) {
            return;
        }
        String prefixedKey = prefix + this.getKey();
        pageParameters.add(prefixedKey, (Object)value);
    }

    public static ComponentHintKey noop() {
        return new ComponentHintKey(null, null, null, null, null){
            private static final long serialVersionUID = 1L;

            @Override
            public String getKey() {
                return null;
            }

            @Override
            public void set(Bookmark bookmark, String value) {
            }

            @Override
            public String get(Bookmark bookmark) {
                return null;
            }

            @Override
            public void remove(Bookmark bookmark) {
            }
        };
    }

    public HintStore getHintStore() {
        this.hintStore = this.computeIfAbsent(HintStore.class, this.hintStore);
        return this.hintStore;
    }

    private <X> X computeIfAbsent(Class<X> type, X existingIfAny) {
        return (X)(existingIfAny != null ? existingIfAny : MetaModelContext.instanceElseFail().lookupServiceElseFail(type));
    }

    @Generated
    private ComponentHintKey(HintStore hintStore, SerializableSupplier<Component> componentProvider, Component component, String keyName, String fullKey) {
        this.hintStore = hintStore;
        this.componentProvider = componentProvider;
        this.component = component;
        this.keyName = keyName;
        this.fullKey = fullKey;
    }
}

