/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.links;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.commons.model.action.HasManagedAction;
import org.apache.causeway.viewer.commons.model.mixin.HasUiComponent;
import org.apache.causeway.viewer.wicket.model.links.ActionLinkUiComponentFactoryWkt;
import org.apache.causeway.viewer.wicket.model.links.Menuable;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.wicket.ajax.markup.html.AjaxLink;

public final class LinkAndLabel
implements Menuable,
HasUiComponent<AjaxLink<ManagedObject>>,
HasManagedAction,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ActionModel actionModel;
    protected final ActionLinkUiComponentFactoryWkt uiComponentFactory;
    private String named;
    private final AtomicReference<Object> uiComponent = new AtomicReference();

    public static LinkAndLabel of(ActionModel actionModel, ActionLinkUiComponentFactoryWkt uiComponentFactory) {
        _Assert.assertNotNull((Object)actionModel.getAction(), (String)"LinkAndLabel requires an Action");
        return new LinkAndLabel(actionModel, uiComponentFactory);
    }

    public ManagedAction getManagedAction() {
        return this.actionModel.getManagedAction();
    }

    public ObjectAction getAction() {
        return this.actionModel.getAction();
    }

    public String toString() {
        return Optional.ofNullable(this.named).orElse("") + " ~ " + this.getAction().getFeatureIdentifier().getFullIdentityString();
    }

    public boolean isVisible() {
        return this.actionModel.getVisibilityConsent().isAllowed();
    }

    public boolean isEnabled() {
        return this.actionModel.getUsabilityConsent().isAllowed();
    }

    public static Predicate<LinkAndLabel> isPositionedAt(ActionLayout.Position panel) {
        return HasManagedAction.isPositionedAt((ActionLayout.Position)panel);
    }

    public boolean isRenderOutlined() {
        return LinkAndLabel.isPositionedAt(ActionLayout.Position.BELOW).or(LinkAndLabel.isPositionedAt(ActionLayout.Position.RIGHT)).test(this);
    }

    @Override
    public Menuable.Kind menuableKind() {
        return Menuable.Kind.LINK;
    }

    private LinkAndLabel(ActionModel actionModel, ActionLinkUiComponentFactoryWkt uiComponentFactory) {
        this.actionModel = actionModel;
        this.uiComponentFactory = uiComponentFactory;
    }

    public ActionModel getActionModel() {
        return this.actionModel;
    }

    public String getNamed() {
        return this.named;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AjaxLink<ManagedObject> getUiComponent() {
        Object $value = this.uiComponent.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.uiComponent;
            synchronized (atomicReference) {
                $value = this.uiComponent.get();
                if ($value == null) {
                    AjaxLink<ManagedObject> actualValue = this.uiComponentFactory.newActionLinkUiComponent(this.actionModel);
                    $value = actualValue == null ? this.uiComponent : actualValue;
                    this.uiComponent.set($value);
                }
            }
        }
        return (AjaxLink)($value == this.uiComponent ? null : $value);
    }
}

