/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import lombok.NonNull;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.MmUnwrapUtils;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.model.ChainingModel;
import org.springframework.util.ClassUtils;

public class ScalarUnwrappingModel<T>
extends ChainingModel<T> {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final Class<T> type;

    public ScalarUnwrappingModel(@NonNull Class<T> type, @NonNull ScalarModel scalarModel) {
        super((Object)scalarModel);
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (scalarModel == null) {
            throw new NullPointerException("scalarModel is marked non-null but is null");
        }
        this.type = type;
        _Assert.assertTrue((boolean)scalarModel.getElementType().isAssignableFrom(type), () -> String.format("cannot possibly unwrap model of type %s into target type %s", scalarModel.getElementType().getCorrespondingClass(), type));
    }

    public T getObject() {
        ManagedObject objectAdapter = this.scalarModel().getObject();
        T pojo = this.unwrap(objectAdapter);
        return pojo;
    }

    public void setObject(T object) {
        ScalarModel scalarModel = this.scalarModel();
        if (object == null) {
            scalarModel.setObject(null);
        } else {
            ManagedObject objectAdapter = scalarModel.getMetaModelContext().getObjectManager().adapt(object);
            scalarModel.setObject(objectAdapter);
        }
    }

    private T unwrap(ManagedObject objectAdapter) {
        Object pojo = MmUnwrapUtils.single((ManagedObject)objectAdapter);
        if (pojo == null || !ClassUtils.resolvePrimitiveIfNecessary(this.type).isAssignableFrom(ClassUtils.resolvePrimitiveIfNecessary(pojo.getClass()))) {
            return null;
        }
        return (T)_Casts.uncheckedCast((Object)pojo);
    }

    private ScalarModel scalarModel() {
        return (ScalarModel)super.getTarget();
    }

    @NonNull
    public Class<T> getType() {
        return this.type;
    }
}

