/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models.interaction;

import lombok.NonNull;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.wicket.model.models.ModelAbstract;
import org.springframework.lang.Nullable;

public final class BookmarkedObjectWkt
extends ModelAbstract<ManagedObject> {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final Bookmark bookmark;

    public static BookmarkedObjectWkt ofAdapter(@NonNull ManagedObject domainObject) {
        if (domainObject == null) {
            throw new NullPointerException("domainObject is marked non-null but is null");
        }
        Bookmark bookmark = domainObject.getBookmarkElseFail();
        return new BookmarkedObjectWkt(bookmark, domainObject);
    }

    public static BookmarkedObjectWkt ofBookmark(@Nullable Bookmark bookmark) {
        return new BookmarkedObjectWkt(bookmark);
    }

    private BookmarkedObjectWkt(@NonNull Bookmark bookmark) {
        if (bookmark == null) {
            throw new NullPointerException("bookmark is marked non-null but is null");
        }
        this.bookmark = bookmark;
    }

    private BookmarkedObjectWkt(@NonNull Bookmark bookmark, @Nullable ManagedObject domainObject) {
        super(domainObject);
        if (bookmark == null) {
            throw new NullPointerException("bookmark is marked non-null but is null");
        }
        this.bookmark = bookmark;
    }

    public final ManagedObject asManagedObject() {
        ManagedObject entityOrViewmodel = (ManagedObject)super.getObject();
        return entityOrViewmodel;
    }

    public final void setObject(ManagedObject object) {
        throw _Exceptions.unsupportedOperation((String)"ManagedObjectWkt is immuatable");
    }

    protected final ManagedObject load() {
        ManagedObject adapter = this.getMetaModelContext().getObjectManager().loadObjectElseFail(this.bookmark);
        return adapter;
    }

    @NonNull
    public Bookmark getBookmark() {
        return this.bookmark;
    }
}

