/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.annotation.TableDecorator;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.commons.model.hints.RenderingHint;
import org.apache.causeway.viewer.wicket.model.links.LinksProvider;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModelParented;
import org.apache.causeway.viewer.wicket.model.models.HasCommonContext;
import org.apache.wicket.model.IModel;

public interface EntityCollectionModel
extends IModel<DataTableInteractive>,
HasCommonContext,
LinksProvider {
    public Identifier getIdentifier();

    public Variant getVariant();

    public DataTableInteractive getDataTableModel();

    public ObjectMember getMetaModel();

    default public ObjectSpecification getElementType() {
        return this.getMetaModel().getElementType();
    }

    public ManagedObject getParentObject();

    default public int getElementCount() {
        return this.getDataTableModel().getFilteredElementCount();
    }

    default public String getName() {
        return (String)this.getDataTableModel().getTitle().getValue();
    }

    default public int getPageSize() {
        return this.getDataTableModel().getPageSize(this.getVariant().getPageSizeDefault());
    }

    default public Optional<TableDecorator> getTableDecoratorIfAny() {
        return this.getDataTableModel().getTableDecoratorIfAny();
    }

    @Deprecated
    default public Optional<EntityCollectionModelParented> parented() {
        return this instanceof EntityCollectionModelParented ? Optional.of((EntityCollectionModelParented)this) : Optional.empty();
    }

    @Deprecated
    default public Optional<Bookmark> parentedHintingBookmark() {
        return this.parented().map(EntityCollectionModelParented::asHintingBookmark);
    }

    public static enum Variant {
        STANDALONE(RenderingHint.STANDALONE_PROPERTY_COLUMN, 25),
        PARENTED(RenderingHint.PARENTED_PROPERTY_COLUMN, 12);

        private final RenderingHint columnRenderingHint;
        private final int pageSizeDefault;

        public RenderingHint getTitleColumnRenderingHint() {
            return this.isParented() ? RenderingHint.PARENTED_TITLE_COLUMN : RenderingHint.STANDALONE_TITLE_COLUMN;
        }

        public boolean isStandalone() {
            return this == STANDALONE;
        }

        public boolean isParented() {
            return this == PARENTED;
        }

        @Generated
        private Variant(RenderingHint columnRenderingHint, int pageSizeDefault) {
            this.columnRenderingHint = columnRenderingHint;
            this.pageSizeDefault = pageSizeDefault;
        }

        @Generated
        public RenderingHint getColumnRenderingHint() {
            return this.columnRenderingHint;
        }

        @Generated
        public int getPageSizeDefault() {
            return this.pageSizeDefault;
        }
    }
}

