/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import lombok.NonNull;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.wicket.model.ChainingModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BooleanModel
extends ChainingModel<Boolean> {
    private static final long serialVersionUID = 1L;
    final boolean isPrimitive;

    public static BooleanModel forAttributeModel(@NonNull UiAttributeWkt attributeModel) {
        if (attributeModel == null) {
            throw new NullPointerException("attributeModel is marked non-null but is null");
        }
        return new BooleanModel(attributeModel);
    }

    protected BooleanModel(UiAttributeWkt attributeModel) {
        super((Object)attributeModel);
        ObjectSpecification spec = this.attributeModel().getElementType();
        this.isPrimitive = spec.getFullIdentifier().equals("boolean");
    }

    public Boolean getObject() {
        ManagedObject adapter = this.attributeModel().getObject();
        Boolean value = adapter != null ? (Boolean)adapter.getPojo() : null;
        return this.isPrimitive && value == null ? Boolean.FALSE : value;
    }

    public void setObject(Boolean value) {
        ManagedObject adaptedValue = ManagedObject.value((ObjectSpecification)this.attributeModel().getElementType(), (Object)(value == null && this.isPrimitive ? Boolean.FALSE : value));
        this.attributeModel().setObject(adaptedValue);
    }

    public IModel<String> asStringModel(final String notSetLiteral, final String trueLiteral, final String falseLiteral) {
        return new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                Boolean bool = BooleanModel.this.getObject();
                return bool == null ? notSetLiteral : (bool != false ? trueLiteral : falseLiteral);
            }
        };
    }

    protected UiAttributeWkt attributeModel() {
        return (UiAttributeWkt)super.getTarget();
    }
}

