/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.MmUnwrapUtils;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.wicket.model.ChainingModel;
import org.springframework.util.ClassUtils;

public class ScalarUnwrappingModel<T>
extends ChainingModel<T> {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final Class<T> type;

    public ScalarUnwrappingModel(@NonNull Class<T> type, @NonNull UiAttributeWkt attributeModel) {
        super((Object)attributeModel);
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (attributeModel == null) {
            throw new NullPointerException("attributeModel is marked non-null but is null");
        }
        this.type = type;
        _Assert.assertTrue((boolean)attributeModel.getElementType().isAssignableFrom(type), () -> String.format("cannot possibly unwrap model of type %s into target type %s", attributeModel.getElementType().getCorrespondingClass(), type));
    }

    public T getObject() {
        ManagedObject objectAdapter = this.attributeModel().getObject();
        T pojo = this.unwrap(objectAdapter);
        return pojo;
    }

    public void setObject(T object) {
        UiAttributeWkt attributeModel = this.attributeModel();
        if (object == null) {
            attributeModel.setObject(null);
        } else {
            ManagedObject objectAdapter = attributeModel.getMetaModelContext().getObjectManager().adapt(object);
            attributeModel.setObject(objectAdapter);
        }
    }

    private T unwrap(ManagedObject objectAdapter) {
        Object pojo = MmUnwrapUtils.single((ManagedObject)objectAdapter);
        if (pojo == null || !ClassUtils.resolvePrimitiveIfNecessary(this.type).isAssignableFrom(ClassUtils.resolvePrimitiveIfNecessary(pojo.getClass()))) {
            return null;
        }
        return (T)_Casts.uncheckedCast((Object)pojo);
    }

    private UiAttributeWkt attributeModel() {
        return (UiAttributeWkt)super.getTarget();
    }

    @NonNull
    @Generated
    public Class<T> getType() {
        return this.type;
    }
}

