/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models.coll;

import java.util.List;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.core.metamodel.tabular.DataTableMemento;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.interaction.BookmarkedObjectWkt;
import org.apache.wicket.model.LoadableDetachableModel;
import org.jspecify.annotations.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class CollectionModelAbstract
extends LoadableDetachableModel<DataTableInteractive>
implements CollectionModel {
    private static final long serialVersionUID = 1L;
    private final @NonNull CollectionModel.Variant variant;
    private final BookmarkedObjectWkt bookmarkedObject;
    private final DataTableMemento tableMemento;
    private List<ActionModel> actionModels = _Lists.newArrayList();

    protected CollectionModelAbstract(BookmarkedObjectWkt bookmarkedObject, DataTableInteractive tableInteractive, @NonNull CollectionModel.Variant variant) {
        this.bookmarkedObject = bookmarkedObject;
        this.tableMemento = tableInteractive.createMemento();
        this.setObject(tableInteractive);
        this.tableMemento.setupBindings(tableInteractive);
        this.variant = variant;
    }

    protected DataTableInteractive load() {
        ManagedObject owner = this.bookmarkedObject.managedObject();
        DataTableInteractive tableInteractive = this.tableMemento.recreateDataTableModel(owner);
        this.tableMemento.setupBindings(tableInteractive);
        return tableInteractive;
    }

    @Override
    public final boolean isTableDataLoaded() {
        return this.isAttached();
    }

    @Override
    public final DataTableInteractive getDataTableModel() {
        return (DataTableInteractive)this.getObject();
    }

    @Override
    public ObjectMember getMetaModel() {
        return this.getDataTableModel().getMetaModel();
    }

    @Override
    public Identifier getIdentifier() {
        return this.getMetaModel().getFeatureIdentifier();
    }

    @Override
    public final ManagedObject getParentObject() {
        return this.bookmarkedObject.managedObject();
    }

    @Override
    public final int getPageSize() {
        return CollectionModel.super.getPageSize();
    }

    @Override
    public final CollectionModel.Variant getVariant() {
        return this.variant;
    }

    public final void setLinkAndLabels(@NonNull Iterable<ActionModel> actionModels) {
        this.actionModels.clear();
        actionModels.forEach(this.actionModels::add);
    }

    @Override
    public final Can<ActionModel> getLinks() {
        return Can.ofCollection(this.actionModels);
    }
}

