/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.whereAmI;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.core.metamodel.util.pchain.ParentChain;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;

public record WhereAmI(UiObjectWkt startOfChain, List<Object> reversedChainOfParents, boolean isWhereAmIEnabled) {
    public static WhereAmI of(UiObjectWkt startOfChain) {
        MetaModelContext mmc = startOfChain.getMetaModelContext();
        CausewayConfiguration.Viewer.Wicket.Breadcrumbs settings = mmc.getConfiguration().getViewer().getWicket().getBreadcrumbs();
        boolean isWhereAmIEnabled = settings.isEnabled();
        int maxChainLength = settings.getMaxParentChainLength();
        ManagedObject adapter = (ManagedObject)startOfChain.getObject();
        Object startNode = adapter.getPojo();
        LinkedList<Object> reversedChainOfParents = new LinkedList<Object>();
        ParentChain.of((SpecificationLoader)mmc.getSpecificationLoader()).streamParentChainOf(startNode, maxChainLength).forEach(reversedChainOfParents::addFirst);
        return new WhereAmI(startOfChain, reversedChainOfParents, isWhereAmIEnabled);
    }

    public boolean isShowWhereAmI() {
        if (!this.isWhereAmIEnabled) {
            return false;
        }
        return !this.reversedChainOfParents.isEmpty();
    }

    public Stream<UiObjectWkt> streamParentChainReversed() {
        if (!this.isWhereAmIEnabled) {
            return Stream.empty();
        }
        return this.reversedChainOfParents.stream().map(this::toEntityModel);
    }

    private UiObjectWkt toEntityModel(Object domainObject) {
        ManagedObject objectAdapter = this.startOfChain.getMetaModelContext().getObjectManager().adapt(domainObject);
        return UiObjectWkt.ofAdapter(objectAdapter);
    }
}

