/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.about;

import java.io.InputStream;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.ServletContext;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.viewer.wicket.model.models.AboutModel;
import org.apache.causeway.viewer.wicket.ui.components.about.JarManifestModel;
import org.apache.causeway.viewer.wicket.ui.components.about.JarManifestPanel;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LambdaModel;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public class AboutPanel
extends PanelAbstract<CausewayConfiguration.Viewer.Common.Application, AboutModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_MANIFEST_ATTRIBUTES = "manifestAttributes";
    private static final String ID_APPLICATION_NAME = "applicationName";
    private static final String ID_APPLICATION_VERSION = "applicationVersion";
    private static final String ID_ABOUT_MESSAGE = "aboutMessage";
    @Inject
    private ServletContext servletContext;
    private JarManifestModel jarManifestModel;

    public AboutPanel(String id, AboutModel aboutModel) {
        super(id);
        this.add(new Component[]{new LabelVisibleOnlyIfNonEmpty(ID_APPLICATION_NAME, (IModel<String>)LambdaModel.of((SerializableSupplier & Serializable)() -> ((CausewayConfiguration.Viewer.Common.Application)aboutModel.getObject()).getName()))});
        this.add(new Component[]{new LabelVisibleOnlyIfNonEmpty(ID_APPLICATION_VERSION, (IModel<String>)LambdaModel.of((SerializableSupplier & Serializable)() -> ((CausewayConfiguration.Viewer.Common.Application)aboutModel.getObject()).getVersion()))});
        this.add(new Component[]{new LabelVisibleOnlyIfNonEmpty(ID_ABOUT_MESSAGE, (IModel<String>)LambdaModel.of((SerializableSupplier & Serializable)() -> ((CausewayConfiguration.Viewer.Common.Application)aboutModel.getObject()).getAbout()))});
        if (this.jarManifestModel == null) {
            Provider metaInfManifestProvider = () -> this.servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");
            this.jarManifestModel = new JarManifestModel((Provider<InputStream>)metaInfManifestProvider);
        }
        this.add(new Component[]{new JarManifestPanel(ID_MANIFEST_ATTRIBUTES, this.jarManifestModel)});
    }

    public static class LabelVisibleOnlyIfNonEmpty
    extends Label {
        private static final long serialVersionUID = 1L;
        private final IModel<String> label;

        public LabelVisibleOnlyIfNonEmpty(String id, IModel<String> label) {
            super(id, label);
            this.label = label;
        }

        protected void onConfigure() {
            super.onConfigure();
            this.setVisibilityAllowed(this.label != null && !_NullSafe.isEmpty((String)((String)this.label.getObject())));
        }
    }
}

