/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.selector;

import java.io.Serializable;
import java.util.Optional;
import org.apache.causeway.applib.layout.component.CollectionLayoutData;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModelParented;
import org.apache.causeway.viewer.wicket.model.util.ComponentHintKey;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryKey;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.multiple.CollectionContentsMultipleViewsPanelFactory;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public class CollectionPresentationSelectorHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String UIHINT_EVENT_VIEW_KEY = "selectedItem";
    private final EntityCollectionModel collectionModel;
    private final Can<ComponentFactoryKey> componentFactories;
    private final ComponentHintKey componentHintKey;

    public CollectionPresentationSelectorHelper(EntityCollectionModel collectionModel, ComponentFactoryRegistry componentFactoryRegistry) {
        this(collectionModel, componentFactoryRegistry, ComponentHintKey.noop());
    }

    public CollectionPresentationSelectorHelper(EntityCollectionModel collectionModel, ComponentFactoryRegistry componentFactoryRegistry, ComponentHintKey componentHintKey) {
        this.collectionModel = collectionModel;
        this.componentFactories = this.gatherComponentFactories(componentFactoryRegistry);
        this.componentHintKey = componentHintKey != null ? componentHintKey : ComponentHintKey.noop();
    }

    private Can<ComponentFactoryKey> gatherComponentFactories(ComponentFactoryRegistry componentFactoryRegistry) {
        return (Can)componentFactoryRegistry.streamComponentFactories((ImmutableEnumSet<UiComponentType>)ImmutableEnumSet.of((Enum)UiComponentType.COLLECTION_CONTENTS, (Enum)UiComponentType.COLLECTION_CONTENTS_EXPORT), (IModel<?>)this.collectionModel).filter(componentFactory -> componentFactory.getClass() != CollectionContentsMultipleViewsPanelFactory.class).map(ComponentFactory::key).collect(Can.toCan());
    }

    public String honourViewHintElseDefault(Component component) {
        String viewStr;
        UiHintContainer hintContainer = CollectionPresentationSelectorHelper.getUiHintContainer(component);
        if (hintContainer != null && (viewStr = hintContainer.getHint(component, UIHINT_EVENT_VIEW_KEY)) != null) {
            return viewStr;
        }
        String initialFactory = this.determineInitialFactory();
        if (hintContainer != null) {
            hintContainer.setHint(component, UIHINT_EVENT_VIEW_KEY, initialFactory);
        }
        return initialFactory;
    }

    private String determineInitialFactory() {
        String defaultView;
        Bookmark bookmark = this.collectionModel.parentedHintingBookmark().orElse(null);
        String sessionAttribute = this.componentHintKey.get(bookmark);
        if (sessionAttribute != null) {
            return sessionAttribute;
        }
        CollectionLayoutData layoutData = CollectionPresentationSelectorHelper.toParentedEntityCollectionModel(this.collectionModel).map(EntityCollectionModelParented::getLayoutData).orElse(null);
        if (layoutData != null && (defaultView = layoutData.getDefaultView()) != null) {
            return defaultView;
        }
        if (CollectionPresentationSelectorHelper.hasDefaultViewFacet(this.collectionModel)) {
            String viewName = (String)Facets.defaultViewName((ObjectFeature)this.collectionModel.getMetaModel()).orElseThrow();
            for (ComponentFactoryKey componentFactory : this.componentFactories) {
                String componentName = componentFactory.id();
                if (!componentName.equalsIgnoreCase(viewName)) continue;
                return componentName;
            }
        }
        return CollectionPresentationSelectorHelper.hasRenderEagerlySemantics(this.collectionModel) || this.collectionModel.getVariant().isStandalone() ? "table" : "hidden";
    }

    private static UiHintContainer getUiHintContainer(Component component) {
        return UiHintContainer.Util.hintContainerOf((Component)component, EntityCollectionModelParented.class);
    }

    private static boolean hasRenderEagerlySemantics(IModel<?> model) {
        return CollectionPresentationSelectorHelper.toParentedEntityCollectionModel(model).map(EntityCollectionModelParented::getMetaModel).map(Facets::defaultViewIsTable).orElse(false);
    }

    private static boolean hasDefaultViewFacet(IModel<?> model) {
        return CollectionPresentationSelectorHelper.toParentedEntityCollectionModel(model).map(EntityCollectionModelParented::getMetaModel).map(Facets::defaultViewIsPresent).orElse(false);
    }

    public ComponentFactoryKey find(String selected) {
        ComponentFactoryKey componentFactory = this.doFind(selected);
        if (componentFactory != null) {
            return componentFactory;
        }
        String fallback = this.collectionModel.getVariant().isParented() ? "hidden" : "table";
        componentFactory = this.doFind(fallback);
        if (componentFactory == null) {
            throw new IllegalStateException(String.format("Could not locate '%s' (as the fallback collection panel)", fallback));
        }
        return componentFactory;
    }

    private ComponentFactoryKey doFind(String selected) {
        for (ComponentFactoryKey componentFactory : this.componentFactories) {
            if (!selected.equals(componentFactory.id())) continue;
            return componentFactory;
        }
        return null;
    }

    public int lookup(String view) {
        int i = 0;
        for (ComponentFactoryKey componentFactory : this.componentFactories) {
            if (view.equals(componentFactory.id())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private static Optional<EntityCollectionModelParented> toParentedEntityCollectionModel(@Nullable IModel<?> model) {
        if (model instanceof EntityCollectionModelParented) {
            return Optional.of((EntityCollectionModelParented)model);
        }
        return Optional.empty();
    }

    public Can<ComponentFactoryKey> getComponentFactories() {
        return this.componentFactories;
    }
}

