/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.CausewayAjaxDataTable;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.TitleColumn;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByBorder;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public abstract class CausewayAjaxHeadersToolbarAbstract<S>
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_SORT_NONE = "fa fa-fw fa-sort";
    private static final String CLASS_SORT_UP = "fa fa-fw fa-sort-up";
    private static final String CLASS_SORT_DOWN = "fa fa-fw fa-sort-down";

    public <T> CausewayAjaxHeadersToolbarAbstract(final DataTable<T, S> table, final ISortStateLocator<S> stateLocator) {
        super(table);
        RefreshingView headers = new RefreshingView<IColumn<T, S>>("headers"){
            private static final long serialVersionUID = 1L;

            protected Iterator<IModel<IColumn<T, S>>> getItemModels() {
                LinkedList<Model> columnsModels = new LinkedList<Model>();
                for (IColumn column : table.getColumns()) {
                    columnsModels.add(Model.of((Serializable)column));
                }
                return columnsModels.iterator();
            }

            protected void populateItem(Item<IColumn<T, S>> item) {
                WebMarkupContainer header;
                final IColumn column = (IColumn)item.getModelObject();
                if (!CausewayAjaxHeadersToolbarAbstract.this.isDecoratedWithDataTablesNet() && column.isSortable()) {
                    header = CausewayAjaxHeadersToolbarAbstract.this.newSortableHeader("header", column.getSortProperty(), stateLocator);
                    if (column instanceof IStyledColumn) {
                        CssAttributeBehavior cssAttributeBehavior = new CssAttributeBehavior(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            protected String getCssClass() {
                                return ((IStyledColumn)column).getCssClass();
                            }
                        };
                        header.add(new Behavior[]{cssAttributeBehavior});
                    }
                } else {
                    header = new WebMarkupContainer("header");
                }
                item.add(new Component[]{header});
                item.setRenderBodyOnly(true);
                Component label = column.getHeader("label");
                Component sortIcon = CausewayAjaxHeadersToolbarAbstract.this.newSortIcon("sortIcon", column, stateLocator);
                header.add(new Component[]{label, sortIcon});
                if (column instanceof TitleColumn) {
                    Wkt.cssAppend(header, "title-column");
                }
            }
        };
        this.add(new Component[]{headers});
    }

    private boolean isDecoratedWithDataTablesNet() {
        return this.getTable() instanceof CausewayAjaxDataTable && ((CausewayAjaxDataTable)this.getTable()).isDecoratedWithDataTablesNet();
    }

    protected <T> Component newSortIcon(String id, final IColumn<T, S> column, final ISortStateLocator<S> stateLocator) {
        return new WebComponent(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (!CausewayAjaxHeadersToolbarAbstract.this.isDecoratedWithDataTablesNet() && column.isSortable()) {
                    SortOrder sortOrder;
                    ISortState sortState = stateLocator.getSortState();
                    Object sortProperty = column.getSortProperty();
                    SortOrder sortOrder2 = sortOrder = sortProperty == null ? SortOrder.NONE : sortState.getPropertySortOrder(sortProperty);
                    if (sortOrder == SortOrder.ASCENDING) {
                        Attributes.addClass((ComponentTag)tag, (String[])new String[]{CausewayAjaxHeadersToolbarAbstract.CLASS_SORT_UP});
                    } else if (sortOrder == SortOrder.DESCENDING) {
                        Attributes.addClass((ComponentTag)tag, (String[])new String[]{CausewayAjaxHeadersToolbarAbstract.CLASS_SORT_DOWN});
                    } else {
                        Attributes.addClass((ComponentTag)tag, (String[])new String[]{CausewayAjaxHeadersToolbarAbstract.CLASS_SORT_NONE});
                    }
                }
            }
        };
    }

    protected WebMarkupContainer newSortableHeader(String headerId, S property, ISortStateLocator<S> locator) {
        return new OrderByBorder<S>(headerId, property, locator){
            private static final long serialVersionUID = 1L;

            protected void onSortChanged() {
                CausewayAjaxHeadersToolbarAbstract.this.getTable().setCurrentPage(0L);
            }
        };
    }

    static abstract class CssAttributeBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        CssAttributeBehavior() {
        }

        protected abstract String getCssClass();

        public void onComponentTag(Component component, ComponentTag tag) {
            String className = this.getCssClass();
            if (!Strings.isEmpty((String)className)) {
                tag.append("class", (CharSequence)className, " ");
            }
        }
    }
}

