/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.scalars.choices;

import java.io.Serializable;
import java.util.Optional;
import org.apache.causeway.applib.services.placeholder.PlaceholderRenderService;
import org.apache.causeway.commons.binding.Bindable;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelSelectAbstract;
import org.apache.causeway.viewer.wicket.ui.components.scalars.choices.ChoiceFormComponent;
import org.apache.causeway.viewer.wicket.ui.components.widgets.entitysimplelink.EntityLinkSimplePanel;
import org.apache.causeway.viewer.wicket.ui.components.widgets.select2.providers.ChoiceProviderDefault;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ObjectChoicesSelect2Panel
extends ScalarPanelSelectAbstract
implements ScalarPanelSelectAbstract.ChoiceTitleHandler {
    private static final long serialVersionUID = 1L;
    private static final String ID_AUTO_COMPLETE = "autoComplete";
    private static final String ID_ENTITY_TITLE_IF_NULL = "entityTitleIfNull";
    private ChoiceFormComponent entityLink;
    private EntityLinkSimplePanel entityLinkOutputFormat;
    private final boolean isCompactFormat;

    public ObjectChoicesSelect2Panel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        this.isCompactFormat = scalarModel.getRenderingHint().isInTable();
    }

    @Override
    protected Component createComponentForOutput(String id) {
        ScalarModel scalarModel = this.scalarModel();
        String name = scalarModel.getFriendlyName();
        this.entityLinkOutputFormat = (EntityLinkSimplePanel)this.getComponentFactoryRegistry().createComponent(UiComponentType.ENTITY_LINK, (IModel<?>)scalarModel);
        this.entityLinkOutputFormat.setOutputMarkupId(true);
        this.entityLinkOutputFormat.setLabel((IModel)Model.of((Serializable)((Object)name)));
        return ScalarFragmentFactory.CompactFragment.ENTITY_LINK.createFragment(id, (MarkupContainer)this, scalarValueId -> this.entityLinkOutputFormat);
    }

    @Override
    protected FormComponent<ManagedObject> createFormComponent(String id, ScalarModel scalarModel) {
        this.entityLink = new ChoiceFormComponent(UiComponentType.ENTITY_LINK.getId(), this);
        this.entityLink.setRequired(scalarModel.isRequired());
        this.select2 = this.createSelect2(ID_AUTO_COMPLETE, ChoiceProviderDefault::new);
        this.entityLink.addOrReplace(new Component[]{this.select2.asComponent()});
        this.entityLink.setOutputMarkupId(true);
        return this.entityLink;
    }

    @Override
    protected final Optional<ScalarFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(ScalarFragmentFactory.InputFragment.SELECT_OBJECT);
    }

    @Override
    protected void onInitializeEditable() {
        super.onInitializeEditable();
        this.syncWithInput();
    }

    @Override
    protected void onInitializeNotEditable() {
        super.onInitializeNotEditable();
        this.syncWithInput();
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        super.onInitializeReadonly(disableReason);
        this.syncWithInput();
    }

    @Override
    protected void onMakeNotEditable(String disableReason) {
        super.onMakeNotEditable(disableReason);
        if (this.isCompactFormat) {
            return;
        }
        this.setTitleAttribute(disableReason);
    }

    @Override
    protected void onMakeEditable() {
        super.onMakeEditable();
        if (this.isCompactFormat) {
            return;
        }
        this.clearTitleAttribute();
    }

    private Optional<MarkupContainer> lookupScalarValueContainer() {
        return Optional.ofNullable(this.getFieldFrame()).flatMap(ScalarFragmentFactory.FieldFrame.SCALAR_VALUE_CONTAINER::lookupIn).map(MarkupContainer.class::cast);
    }

    private void syncWithInput() {
        if (this.isCompactFormat) {
            return;
        }
        ScalarModel scalarModel = this.scalarModel();
        this.lookupScalarValueContainer().ifPresent(container -> {
            ManagedObject adapter;
            ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(UiComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)scalarModel);
            Component iconAndTitle = componentFactory.createComponent(UiComponentType.ENTITY_ICON_AND_TITLE.getId(), (IModel<?>)scalarModel);
            container.addOrReplace(new Component[]{iconAndTitle});
            boolean isInlinePrompt = scalarModel.isInlinePrompt();
            if (isInlinePrompt) {
                iconAndTitle.setVisible(false);
            }
            if ((adapter = scalarModel.getObject()) != null || isInlinePrompt) {
                WktComponents.permanentlyHide(container, ID_ENTITY_TITLE_IF_NULL);
            } else {
                Wkt.markupAdd(container, ID_ENTITY_TITLE_IF_NULL, this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
            }
        });
        if (!this.isEditable()) {
            WktComponents.permanentlyHide((MarkupContainer)this.entityLink, ID_AUTO_COMPLETE);
            return;
        }
        if (this.fieldFrame != null) {
            WktComponents.permanentlyHide(this.fieldFrame, ID_ENTITY_TITLE_IF_NULL);
        }
        WktComponents.permanentlyHide((MarkupContainer)this.entityLink, ID_ENTITY_TITLE_IF_NULL);
        if (this.select2 == null) {
            throw new IllegalStateException("select2 should be created already");
        }
        this.select2.setEnabled(this.entityLink.isEnableAllowed() && !((ScalarModel)this.getModel()).isViewingMode());
        if (!this.hasAnyChoices()) {
            // empty if block
        }
    }

    String getTitleForFormComponentInput() {
        ManagedObject pendingElseCurrentAdapter = this.scalarModel().getObject();
        return pendingElseCurrentAdapter != null ? pendingElseCurrentAdapter.getTitle() : "(no object)";
    }

    void convertInput() {
        ScalarModel scalarModel = this.scalarModel();
        Bindable pendingValue = scalarModel.proposedValue().getValue();
        if (this.isEditable()) {
            ManagedObject adapter = this.select2.getConvertedInputValue();
            pendingValue.setValue((Object)adapter);
        }
        this.entityLink.setConvertedInput((ManagedObject)pendingValue.getValue());
    }

    @Override
    public void clearTitleAttribute() {
        this.entityLink.setEnabled(true);
        Wkt.attributeReplace(this.entityLink, "title", "");
    }

    @Override
    public void setTitleAttribute(String titleAttribute) {
        if (_Strings.isNullOrEmpty((CharSequence)titleAttribute)) {
            this.clearTitleAttribute();
            return;
        }
        this.entityLink.setEnabled(false);
        Wkt.attributeReplace(this.entityLink, "title", titleAttribute);
    }
}

