/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.widgets.linkandlabel;

import java.io.Serializable;
import lombok.NonNull;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.debug._Probe;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.ActionPrompt;
import org.apache.causeway.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.causeway.viewer.wicket.model.models.ActionPromptWithExtraContent;
import org.apache.causeway.viewer.wicket.model.models.FormExecutor;
import org.apache.causeway.viewer.wicket.model.models.FormExecutorContext;
import org.apache.causeway.viewer.wicket.model.models.InlinePromptContext;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.app.registry.HasComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.components.actions.ActionParametersPanel;
import org.apache.causeway.viewer.wicket.ui.components.layout.bs.BSGridPanel;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.causeway.viewer.wicket.ui.panels.FormExecutorDefault;
import org.apache.causeway.viewer.wicket.ui.panels.PanelUtil;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxIndicatorAppender;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;

public final class ActionLink
extends IndicatingAjaxLink<ManagedObject>
implements HasMetaModelContext {
    private static final long serialVersionUID = 1L;
    private final AjaxIndicatorAppender indicatorAppenderIfAny;
    protected transient MetaModelContext commonContext;

    public static ActionLink create(@NonNull String linkId, @NonNull ActionModel actionModel) {
        if (linkId == null) {
            throw new NullPointerException("linkId is marked non-null but is null");
        }
        if (actionModel == null) {
            throw new NullPointerException("actionModel is marked non-null but is null");
        }
        ActionLink actionLink = new ActionLink(linkId, actionModel);
        return Wkt.cssAppend(actionLink, "noVeil");
    }

    private ActionLink(String id, ActionModel model) {
        super(id, (IModel)model);
        this.commonContext = model.getMetaModelContext();
        boolean useIndicatorForNoArgAction = this.getSettings().isUseIndicatorForNoArgAction();
        AjaxIndicatorAppender ajaxIndicatorAppender = this.indicatorAppenderIfAny = useIndicatorForNoArgAction ? new AjaxIndicatorAppender() : null;
        if (this.indicatorAppenderIfAny != null) {
            this.add(new Behavior[]{this.indicatorAppenderIfAny});
        }
    }

    public ActionModel getActionModel() {
        return (ActionModel)this.getModel();
    }

    public ObjectAction getObjectAction() {
        return this.getActionModel().getAction();
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        if (this.getSettings().isPreventDoubleClickForNoArgAction()) {
            PanelUtil.disableBeforeReenableOnComplete(attributes, (Component)this);
        }
        attributes.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
    }

    public String getReasonDisabledIfAny() {
        return this.isVisible() ? (String)this.getActionModel().getUsabilityConsent().getReasonAsString().orElse(null) : null;
    }

    public boolean isVisible() {
        return this.getActionModel().getVisibilityConsent().isAllowed();
    }

    public boolean isEnabled() {
        return this.getActionModel().getUsabilityConsent().isAllowed();
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Wkt.fixDisabledState((Component)this, tag);
    }

    public String getAjaxIndicatorMarkupId() {
        return this.indicatorAppenderIfAny != null ? this.indicatorAppenderIfAny.getMarkupId() : null;
    }

    public void onClick(AjaxRequestTarget target) {
        _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User clicking an Action Link.");
        ActionModel actionModel = this.getActionModel();
        if (actionModel.getPromptStyle().isDialogAny() || actionModel.getInlinePromptContext() == null) {
            if (actionModel.hasParameters()) {
                this.startDialogWithParams(target);
            } else {
                this.executeWithoutParams();
            }
        } else {
            this.startDialogInline(target);
        }
    }

    private void executeWithoutParams() {
        ActionModel actionModel = this.getActionModel();
        FormExecutor.FormExecutionOutcome outcome = FormExecutorDefault.forAction(actionModel).executeAndProcessResults(null, null, (FormExecutorContext)actionModel);
        if (outcome.isFailure()) {
            ManagedObject targetAdapter = actionModel.getParentObject();
            Bookmark bookmark = (Bookmark)targetAdapter.refreshBookmark().orElseThrow();
            this.getMetaModelContext().getTransactionService().flushTransaction();
            RequestCycle.get().setResponsePage(EntityPage.class, PageParameterUtils.createPageParametersForBookmark((Bookmark)bookmark));
        }
    }

    private void startDialogWithParams(AjaxRequestTarget target) {
        ActionModel actionModel = this.getActionModel();
        ObjectSpecification actionOwnerSpec = actionModel.getActionOwner().getSpecification();
        ActionPrompt actionPrompt = ActionPromptProvider.getFrom((Page)this.getPage()).getActionPrompt(actionModel.getPromptStyle(), actionOwnerSpec.getBeanSort());
        ActionParametersPanel actionParametersPanel = (ActionParametersPanel)this.getComponentFactoryRegistry().createComponent(actionPrompt.getContentId(), UiComponentType.ACTION_PROMPT, (IModel<?>)actionModel);
        actionParametersPanel.setShowHeader(false);
        Label label = Wkt.label(actionPrompt.getTitleId(), (IModel<String>)((IModel & Serializable)() -> ((ActionModel)actionModel).getFriendlyName()));
        actionPrompt.setTitle((Component)label, target);
        actionPrompt.setPanel((Component)actionParametersPanel, target);
        actionPrompt.showPrompt(target);
        _Casts.castTo(ActionPromptWithExtraContent.class, (Object)actionPrompt).ifPresent(promptWithExtraContent -> BSGridPanel.extraContentForMixin(promptWithExtraContent.getExtraContentId(), actionModel).ifPresent(gridPanel -> promptWithExtraContent.setExtraContentPanel((Component)gridPanel, target)));
    }

    private void startDialogInline(AjaxRequestTarget target) {
        ActionModel actionModel = this.getActionModel();
        InlinePromptContext inlinePromptContext = actionModel.getInlinePromptContext();
        MarkupContainer scalarTypeContainer = inlinePromptContext.getScalarTypeContainer();
        this.getComponentFactoryRegistry().addOrReplaceComponent(scalarTypeContainer, ScalarFragmentFactory.FrameFragment.INLINE_PROMPT_FORM.getContainerId(), UiComponentType.PARAMETERS, (IModel<?>)actionModel);
        inlinePromptContext.onPrompt();
        Wkt.javaScriptAdd(target, Wkt.EventTopic.FOCUS_FIRST_PARAMETER, scalarTypeContainer.getMarkupId());
        target.add(new Component[]{scalarTypeContainer});
    }

    private ComponentFactoryRegistry getComponentFactoryRegistry() {
        return ((HasComponentFactoryRegistry)Application.get()).getComponentFactoryRegistry();
    }

    public CausewayConfiguration.Viewer.Wicket getSettings() {
        return this.getMetaModelContext().getConfiguration().getViewer().getWicket();
    }
}

