/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.widgets.select2.providers;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.applib.services.i18n.TranslationService;
import org.apache.causeway.applib.services.placeholder.PlaceholderRenderService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.causeway.core.metamodel.objectmanager.memento.ObjectMementoForEmpty;
import org.apache.causeway.viewer.wicket.model.models.HasCommonContext;
import org.apache.wicket.util.string.Strings;
import org.springframework.lang.Nullable;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Response;

public abstract class ChoiceProviderAbstract
extends ChoiceProvider<ObjectMemento>
implements HasCommonContext {
    private static final long serialVersionUID = 1L;

    protected abstract boolean isRequired();

    protected abstract Can<ObjectMemento> query(@Nullable String var1);

    public final String getDisplayValue(ObjectMemento choiceMemento) {
        if (choiceMemento == null || choiceMemento instanceof ObjectMementoForEmpty) {
            return this.getPlaceholderRenderService().asText(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION);
        }
        return this.translate(choiceMemento.getTitle());
    }

    public final String getIdValue(ObjectMemento choiceMemento) {
        if (choiceMemento == null) {
            return "VGN6r6zKTiLhUsA0WkdQ17LvMU1IYdb0";
        }
        return ObjectMemento.enstringToUrlBase64((ObjectMemento)choiceMemento);
    }

    @Nullable
    protected final ObjectMemento mementoFromId(@Nullable String id) {
        return ObjectMemento.destringFromUrlBase64((String)id);
    }

    public final void query(String term, int page, Response<ObjectMemento> response) {
        Can<ObjectMemento> mementosFiltered = this.query(term);
        if (this.isRequired()) {
            response.addAll((Collection)mementosFiltered.toList());
            return;
        }
        List mementosIncludingNull = mementosFiltered.toArrayList();
        mementosIncludingNull.add(0, null);
        response.addAll((Collection)mementosIncludingNull);
    }

    public final Collection<ObjectMemento> toChoices(Collection<String> ids) {
        return _NullSafe.stream(ids).map(this::mementoFromIdWithNullHandling).collect(Collectors.toList());
    }

    protected final Can<ObjectMemento> filter(String term, Can<ObjectMemento> choiceMementos) {
        if (Strings.isEmpty((String)term)) {
            return choiceMementos;
        }
        TranslationContext translationContext = TranslationContext.empty();
        TranslationService translator = this.getTranslationService();
        String termLower = term.toLowerCase();
        return choiceMementos.filter(candidateMemento -> {
            String title = translator.translate(translationContext, candidateMemento.getTitle());
            return title.toLowerCase().contains(termLower);
        });
    }

    @Nullable
    private ObjectMemento mementoFromIdWithNullHandling(String id) {
        if ("VGN6r6zKTiLhUsA0WkdQ17LvMU1IYdb0".equals(id)) {
            return null;
        }
        return this.mementoFromId(id);
    }
}

