/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages;

import de.agilecoders.wicket.core.markup.html.references.BootstrapJavaScriptReference;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.causeway.applib.annotation.PromptStyle;
import org.apache.causeway.applib.services.exceprecog.ExceptionRecognizerService;
import org.apache.causeway.applib.services.metamodel.BeanSort;
import org.apache.causeway.applib.services.publishing.spi.PageRenderSubscriber;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.having.HasEnabling;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Timing;
import org.apache.causeway.commons.internal.debug._Debug;
import org.apache.causeway.commons.internal.debug.xray.XrayUi;
import org.apache.causeway.core.config.viewer.web.DialogMode;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.hints.CausewayEnvelopeEvent;
import org.apache.causeway.viewer.wicket.model.hints.CausewayEventLetterAbstract;
import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.causeway.viewer.wicket.model.models.ActionPrompt;
import org.apache.causeway.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.causeway.viewer.wicket.model.models.BookmarkableModel;
import org.apache.causeway.viewer.wicket.model.models.BookmarkedPagesModel;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.app.registry.HasComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.components.actionprompt.ActionPromptModalWindow;
import org.apache.causeway.viewer.wicket.ui.components.actionpromptsb.ActionPromptSidebar;
import org.apache.causeway.viewer.wicket.ui.components.scalars.image.JavaAwtImagePanelCssResourceReference;
import org.apache.causeway.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.causeway.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.causeway.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.causeway.viewer.wicket.ui.errors.JGrowlBehaviour;
import org.apache.causeway.viewer.wicket.ui.pages.BookmarkedPagesModelProvider;
import org.apache.causeway.viewer.wicket.ui.pages.WebPageBase;
import org.apache.causeway.viewer.wicket.ui.pages.common.bootstrap.css.BootstrapOverridesCssResourceReference;
import org.apache.causeway.viewer.wicket.ui.pages.common.fontawesome.FontAwesomeCssReferenceWkt;
import org.apache.causeway.viewer.wicket.ui.pages.common.livequery.js.LiveQueryJsResourceReference;
import org.apache.causeway.viewer.wicket.ui.pages.common.sidebar.css.SidebarCssResourceReference;
import org.apache.causeway.viewer.wicket.ui.pages.common.viewer.js.CausewayWicketViewerJsResourceReference;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.devutils.debugbar.DebugBar;
import org.apache.wicket.devutils.debugbar.IDebugBarContributor;
import org.apache.wicket.devutils.debugbar.InspectorDebugPanel;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.head.filter.HeaderResponseContainer;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class PageAbstract
extends WebPageBase
implements ActionPromptProvider {
    private static final Logger log = LogManager.getLogger(PageAbstract.class);
    private static final long serialVersionUID = 1L;
    private static final String ID_THEME = "theme";
    private static final String ID_BOOKMARKED_PAGES = "bookmarks";
    private static final String ID_ACTION_PROMPT_MODAL_WINDOW = "actionPromptModalWindow";
    private static final String ID_ACTION_PROMPT_SIDEBAR = "actionPromptSidebar";
    private static final String ID_PAGE_TITLE = "pageTitle";
    public static final String ID_MENU_LINK = "menuLink";
    public static final String UIHINT_FOCUS = "focus";
    public static final ThreadLocal<ExceptionModel> EXCEPTION = new ThreadLocal();
    private final List<UiComponentType> childComponentIds;
    protected MarkupContainer themeDiv;
    private ActionPromptModalWindow actionPromptModalWindow;
    private ActionPromptSidebar actionPromptSidebar;

    protected PageAbstract(PageParameters pageParameters, String title, UiComponentType ... childComponentIds) {
        super(pageParameters);
        try {
            this.getSession().bind();
            this.setTitle(title);
            MarkupContainer header = this.createPageHeader("header");
            this.add(new Component[]{header});
            this.themeDiv = Wkt.containerAdd((MarkupContainer)this, ID_THEME);
            String applicationName = this.getApplicationSettings().getName();
            Wkt.cssAppend(this.themeDiv, Wkt.cssNormalize(applicationName));
            boolean devUtilitiesEnabled = this.getApplication().getDebugSettings().isDevelopmentUtilitiesEnabled();
            DebugBar debugBar = devUtilitiesEnabled ? this.newDebugBar("debugBar") : new EmptyPanel("debugBar").setVisible(false);
            this.add(new Component[]{debugBar});
            MarkupContainer footer = this.createPageFooter("footer");
            this.themeDiv.add(new Component[]{footer});
            this.addActionPromptModalWindow(this.themeDiv);
            this.addActionPromptSidebar(this.themeDiv);
            this.childComponentIds = List.of(childComponentIds);
            this.add(new Component[]{new HeaderResponseContainer("footerJS", "footerJS")});
        }
        catch (RuntimeException ex) {
            log.error("Failed to construct page, going back to sign in page", (Throwable)ex);
            ExceptionRecognizerService exceptionRecognizerService = (ExceptionRecognizerService)this.getMetaModelContext().getServiceRegistry().lookupServiceElseFail(ExceptionRecognizerService.class);
            Optional recognition = exceptionRecognizerService.recognize((Throwable)ex);
            ExceptionModel exceptionModel = ExceptionModel.create(this.getMetaModelContext(), recognition, ex);
            this.getSession().invalidate();
            this.getSession().clear();
            EXCEPTION.set(exceptionModel);
            throw new RestartResponseAtInterceptPageException(this.getSignInPage());
        }
    }

    protected DebugBar newDebugBar(String id) {
        DebugBar debugBar = new DebugBar(id);
        List contributors = DebugBar.getContributors((Application)this.getApplication());
        Iterator iterator = contributors.iterator();
        while (iterator.hasNext()) {
            IDebugBarContributor contributor = (IDebugBarContributor)iterator.next();
            if (contributor != InspectorDebugPanel.DEBUG_BAR_CONTRIB) continue;
            iterator.remove();
        }
        return debugBar;
    }

    protected MarkupContainer createPageHeader(String id) {
        Component header = this.getComponentFactoryRegistry().createComponent(id, UiComponentType.HEADER, null);
        return (MarkupContainer)header;
    }

    protected MarkupContainer createPageFooter(String id) {
        Component footer = this.getComponentFactoryRegistry().createComponent(id, UiComponentType.FOOTER, null);
        return (MarkupContainer)footer;
    }

    protected void setTitle(String title) {
        Wkt.labelAdd((MarkupContainer)this, ID_PAGE_TITLE, title != null ? title : this.getApplicationSettings().getName());
    }

    private Class<? extends Page> getSignInPage() {
        return this.getPageClassRegistry().getPageClass(PageType.SIGN_IN);
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        Component childComponent;
        String path;
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)this.getApplication().getJavaScriptLibrarySettings().getJQueryReference())));
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapJavaScriptReference.instance())));
        response.render((HeaderItem)FontAwesomeCssReferenceWkt.asHeaderItem());
        response.render((HeaderItem)BootstrapOverridesCssResourceReference.asHeaderItem());
        BootstrapOverridesCssResourceReference.contributeThemeSpecificOverrides(this.getApplication(), response);
        response.render((HeaderItem)SidebarCssResourceReference.asHeaderItem());
        response.render((HeaderItem)JavaAwtImagePanelCssResourceReference.asHeaderItem());
        response.render((HeaderItem)LiveQueryJsResourceReference.asHeaderItem());
        response.render(CausewayWicketViewerJsResourceReference.asHeaderItem());
        new JGrowlBehaviour().renderFeedbackMessages(response);
        this.getWicketViewerSettings().getCss().ifPresent(applicationCss -> response.render((HeaderItem)CssReferenceHeaderItem.forUrl((String)applicationCss)));
        this.getWicketViewerSettings().getJs().ifPresent(applicationJs -> response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)applicationJs)));
        this.getWicketViewerSettings().getLiveReloadUrl().ifPresent(liveReloadUrl -> response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)liveReloadUrl)));
        if (this.getSystemEnvironment().isPrototyping()) {
            this.addBootLint(response);
        }
        String markupId = null;
        UiHintContainer hintContainer = this.getUiHintContainerIfAny();
        if (hintContainer != null && (path = hintContainer.getHint((Component)this.getPage(), UIHINT_FOCUS)) != null && (childComponent = this.get(path)) != null) {
            markupId = childComponent.getMarkupId();
        }
        Wkt.javaScriptAdd(response, Wkt.EventTopic.FOCUS_FIRST_PROPERTY, markupId);
    }

    protected UiHintContainer getUiHintContainerIfAny() {
        return null;
    }

    private void addBootLint(IHeaderResponse response) {
    }

    public List<UiComponentType> getChildModelTypes() {
        return this.childComponentIds;
    }

    protected void addChildComponents(MarkupContainer container, IModel<?> model) {
        for (UiComponentType uiComponentType : this.getChildModelTypes()) {
            this.addComponent(container, uiComponentType, model);
        }
    }

    private void addComponent(MarkupContainer container, UiComponentType uiComponentType, IModel<?> model) {
        this.getComponentFactoryRegistry().addOrReplaceComponent(container, uiComponentType, model);
    }

    protected void addBookmarkedPages(MarkupContainer container) {
        Component bookmarks = this.getBookmarkedPagesModel().map(bm -> this.getComponentFactoryRegistry().createComponent(ID_BOOKMARKED_PAGES, UiComponentType.BOOKMARKED_PAGES, (IModel<?>)bm)).orElseGet(() -> new EmptyPanel(ID_BOOKMARKED_PAGES).setVisible(false));
        container.add(new Component[]{bookmarks});
        bookmarks.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                super.onConfigure(component);
                PageParameters parameters = PageAbstract.this.getPageParameters();
                component.setVisible(parameters.get("causeway.no.header").isNull());
            }
        }});
    }

    private boolean isShowBookmarks() {
        return this.getWicketViewerSettings().getBookmarkedPages().isShowChooser();
    }

    protected boolean isShowBreadcrumbs() {
        return this.getWicketViewerSettings().getBookmarkedPages().isShowDropDownOnFooter();
    }

    protected void bookmarkPageIfShown(BookmarkableModel model) {
        this.getBookmarkedPagesModel().ifPresent(bm -> bm.bookmarkPage(model));
    }

    protected void removeAnyBookmark(UiObjectWkt model) {
        this.getBookmarkedPagesModel().ifPresent(bm -> bm.remove(model));
    }

    private Optional<BookmarkedPagesModel> getBookmarkedPagesModel() {
        return this.isShowBookmarks() ? _Casts.castTo(BookmarkedPagesModelProvider.class, (Object)this.getSession()).map(BookmarkedPagesModelProvider::getBookmarkedPagesModel) : Optional.empty();
    }

    protected Optional<BreadcrumbModel> getBreadcrumbModel() {
        return this.isShowBreadcrumbs() ? _Casts.castTo(BreadcrumbModelProvider.class, (Object)this.getSession()).map(BreadcrumbModelProvider::getBreadcrumbModel) : Optional.empty();
    }

    public ActionPrompt getActionPrompt(PromptStyle promptStyle, BeanSort sort) {
        switch (promptStyle) {
            case DIALOG_SIDEBAR: {
                return this.actionPromptSidebar;
            }
            case DIALOG_MODAL: {
                return this.actionPromptModalWindow;
            }
        }
        DialogMode dialogMode = sort.isManagedBeanAny() ? this.getWicketViewerSettings().getDialogModeForMenu() : this.getWicketViewerSettings().getDialogMode();
        switch (dialogMode) {
            case SIDEBAR: {
                return this.actionPromptSidebar;
            }
        }
        return this.actionPromptModalWindow;
    }

    public void closePrompt(AjaxRequestTarget target) {
        this.actionPromptSidebar.closePrompt(target);
        this.actionPromptModalWindow.closePrompt(target);
    }

    private void addActionPromptModalWindow(MarkupContainer parent) {
        this.actionPromptModalWindow = ActionPromptModalWindow.newModalWindow(ID_ACTION_PROMPT_MODAL_WINDOW);
        parent.addOrReplace(new Component[]{this.actionPromptModalWindow});
    }

    private void addActionPromptSidebar(MarkupContainer parent) {
        this.actionPromptSidebar = ActionPromptSidebar.newSidebar(ID_ACTION_PROMPT_SIDEBAR);
        parent.addOrReplace(new Component[]{this.actionPromptSidebar});
    }

    public void onEvent(IEvent<?> event) {
        _Casts.castTo(CausewayEventLetterAbstract.class, (Object)event.getPayload()).ifPresent(letter -> this.send((IEventSink)this, Broadcast.BREADTH, new CausewayEnvelopeEvent(letter)));
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        HasComponentFactoryRegistry cfra = (HasComponentFactoryRegistry)this.getApplication();
        return cfra.getComponentFactoryRegistry();
    }

    public void renderPage() {
        PageRenderSubscriber.PageType pageType = Optional.ofNullable(this.getPageClassRegistry().getPageType(this)).map(PageType::asApplibPageType).orElse(PageRenderSubscriber.PageType.OTHER);
        Can<PageRenderSubscriber> enabledPageRenderSubscribers = this.enabledPageRenderSubscriber();
        enabledPageRenderSubscribers.forEach(subscriber -> subscriber.onRendering(pageType));
        if (XrayUi.isXrayEnabled()) {
            _Debug.log((String)"about to render %s ..", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            _Timing.StopWatch stopWatch = _Timing.now();
            this.onNewRequestCycle();
            super.renderPage();
            stopWatch.stop();
            _Debug.log((String)".. rendering took %s", (Object[])new Object[]{stopWatch.toString()});
        } else {
            this.onNewRequestCycle();
            super.renderPage();
        }
        this.onRendered(enabledPageRenderSubscribers);
    }

    public void onNewRequestCycle() {
    }

    protected void onRendered(Can<PageRenderSubscriber> enabledObjectRenderSubscribers) {
    }

    private Can<PageRenderSubscriber> enabledPageRenderSubscriber() {
        return this.getServiceRegistry().select(PageRenderSubscriber.class).filter(HasEnabling::isEnabled);
    }
}

