/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.actionresponse;

import java.net.URL;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.applib.value.Clob;
import org.apache.causeway.applib.value.LocalResourcePath;
import org.apache.causeway.applib.value.OpenUrlStrategy;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.config.viewer.web.WebAppContextPath;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.object.PackedManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModelStandalone;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.model.models.VoidModel;
import org.apache.causeway.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.causeway.viewer.wicket.ui.actionresponse.PageRedirectRequest;
import org.apache.causeway.viewer.wicket.ui.actionresponse._DownloadHandler;
import org.apache.causeway.viewer.wicket.ui.actionresponse._RedirectHandler;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.causeway.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.causeway.viewer.wicket.ui.pages.standalonecollection.StandaloneCollectionPage;
import org.apache.causeway.viewer.wicket.ui.pages.value.ValuePage;
import org.apache.causeway.viewer.wicket.ui.pages.voidreturn.VoidReturnPage;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.PageRequestHandlerTracker;
import org.apache.wicket.request.cycle.RequestCycle;
import org.springframework.lang.Nullable;

public enum ActionResultResponseType {
    OBJECT{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @NonNull ManagedObject resultAdapter) {
            if (resultAdapter == null) {
                throw new NullPointerException("resultAdapter is marked non-null but is null");
            }
            ActionResultResponseType.determineScalarAdapter(actionModel.getMetaModelContext(), resultAdapter);
            return 1.toEntityPage(resultAdapter);
        }

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, ManagedObject targetAdapter) {
            return 1.toEntityPage(targetAdapter);
        }
    }
    ,
    COLLECTION{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @NonNull ManagedObject resultAdapter) {
            if (resultAdapter == null) {
                throw new NullPointerException("resultAdapter is marked non-null but is null");
            }
            _Assert.assertTrue((boolean)(resultAdapter instanceof PackedManagedObject));
            EntityCollectionModelStandalone collectionModel = EntityCollectionModelStandalone.forActionModel((PackedManagedObject)((PackedManagedObject)resultAdapter), (ActionModel)actionModel);
            return ActionResultResponse.toPage(StandaloneCollectionPage.class, new StandaloneCollectionPage(collectionModel));
        }
    }
    ,
    VALUE{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @NonNull ManagedObject resultAdapter) {
            if (resultAdapter == null) {
                throw new NullPointerException("resultAdapter is marked non-null but is null");
            }
            ValueModel valueModel = ValueModel.of((ObjectMember)actionModel.getAction(), (ManagedObject)resultAdapter);
            valueModel.setActionHint(actionModel);
            ValuePage valuePage = new ValuePage(valueModel);
            return ActionResultResponse.toPage(ValuePage.class, valuePage);
        }
    }
    ,
    VALUE_CLOB{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @NonNull ManagedObject resultAdapter) {
            if (resultAdapter == null) {
                throw new NullPointerException("resultAdapter is marked non-null but is null");
            }
            Object value = resultAdapter.getPojo();
            IRequestHandler handler = _DownloadHandler.downloadHandler(actionModel.getAction(), value);
            return ActionResultResponse.withHandler(handler);
        }
    }
    ,
    VALUE_BLOB{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @NonNull ManagedObject resultAdapter) {
            if (resultAdapter == null) {
                throw new NullPointerException("resultAdapter is marked non-null but is null");
            }
            Object value = resultAdapter.getPojo();
            IRequestHandler handler = _DownloadHandler.downloadHandler(actionModel.getAction(), value);
            return ActionResultResponse.withHandler(handler);
        }
    }
    ,
    VALUE_LOCALRESPATH_AJAX{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @NonNull ManagedObject resultAdapter) {
            if (resultAdapter == null) {
                throw new NullPointerException("resultAdapter is marked non-null but is null");
            }
            LocalResourcePath localResPath = (LocalResourcePath)resultAdapter.getPojo();
            WebAppContextPath webAppContextPath = actionModel.getMetaModelContext().getWebAppContextPath();
            return ActionResultResponse.openUrlInBrowser(target, localResPath.getEffectivePath(arg_0 -> ((WebAppContextPath)webAppContextPath).prependContextPath(arg_0)), localResPath.getOpenUrlStrategy());
        }
    }
    ,
    VALUE_LOCALRESPATH_NOAJAX{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @NonNull ManagedObject resultAdapter) {
            if (resultAdapter == null) {
                throw new NullPointerException("resultAdapter is marked non-null but is null");
            }
            LocalResourcePath localResPath = (LocalResourcePath)resultAdapter.getPojo();
            WebAppContextPath webAppContextPath = actionModel.getMetaModelContext().getWebAppContextPath();
            IRequestHandler handler = _RedirectHandler.redirectHandler(localResPath, localResPath.getOpenUrlStrategy(), webAppContextPath);
            return ActionResultResponse.withHandler(handler);
        }
    }
    ,
    VALUE_URL_AJAX{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @NonNull ManagedObject resultAdapter) {
            if (resultAdapter == null) {
                throw new NullPointerException("resultAdapter is marked non-null but is null");
            }
            URL url = (URL)resultAdapter.getPojo();
            return ActionResultResponse.openUrlInBrowser(target, url.toString(), OpenUrlStrategy.NEW_WINDOW);
        }
    }
    ,
    VALUE_URL_NOAJAX{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @NonNull ManagedObject resultAdapter) {
            if (resultAdapter == null) {
                throw new NullPointerException("resultAdapter is marked non-null but is null");
            }
            Object value = resultAdapter.getPojo();
            WebAppContextPath webAppContextPath = actionModel.getMetaModelContext().getWebAppContextPath();
            IRequestHandler handler = _RedirectHandler.redirectHandler(value, OpenUrlStrategy.NEW_WINDOW, webAppContextPath);
            return ActionResultResponse.withHandler(handler);
        }
    }
    ,
    VOID_AS_EMPTY{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @Nullable ManagedObject resultAdapter) {
            VoidModel voidModel = new VoidModel();
            voidModel.setActionHint(actionModel);
            return ActionResultResponse.toPage(VoidReturnPage.class, new VoidReturnPage(voidModel));
        }
    }
    ,
    VOID_AS_RELOAD{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @Nullable ManagedObject resultAdapter) {
            IRequestablePage currentPage = PageRequestHandlerTracker.getLastHandler((RequestCycle)RequestCycle.get()).getPage();
            Class<?> pageClass = currentPage.getClass();
            return ActionResultResponse.toPage(PageRedirectRequest.forPage(pageClass, (IRequestablePage)_Casts.uncheckedCast((Object)currentPage)));
        }
    }
    ,
    SIGN_IN{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, @Nullable ManagedObject resultAdapter) {
            Class<? extends Page> signInPage = ((PageClassRegistry)actionModel.getMetaModelContext().lookupServiceElseFail(PageClassRegistry.class)).getPageClass(PageType.SIGN_IN);
            return ActionResultResponse.toPage(PageRedirectRequest.forPageClass(signInPage));
        }
    };


    public abstract ActionResultResponse interpretResult(ActionModel var1, AjaxRequestTarget var2, ManagedObject var3);

    public ActionResultResponse interpretResult(ActionModel model, ManagedObject targetAdapter) {
        throw new UnsupportedOperationException("Cannot render concurrency exception for any result type other than OBJECT");
    }

    public static ActionResultResponse determineAndInterpretResult(ActionModel model, AjaxRequestTarget targetIfAny, @Nullable ManagedObject resultAdapter) {
        ActionResultResponseType mapAbsentResultTo = VOID_AS_EMPTY;
        TypeAndAdapter typeAndAdapter = ActionResultResponseType.determineFor(resultAdapter, mapAbsentResultTo, targetIfAny);
        return typeAndAdapter.type.interpretResult(model, targetIfAny, typeAndAdapter.resultAdapter);
    }

    public static ActionResultResponse toEntityPage(@NonNull ManagedObject entityOrViewmodel) {
        if (entityOrViewmodel == null) {
            throw new NullPointerException("entityOrViewmodel is marked non-null but is null");
        }
        return ActionResultResponse.toPage(EntityPage.class, (Bookmark)entityOrViewmodel.refreshBookmark().orElseThrow());
    }

    private static ManagedObject determineScalarAdapter(@NonNull MetaModelContext commonContext, @NonNull ManagedObject resultAdapter) {
        if (commonContext == null) {
            throw new NullPointerException("commonContext is marked non-null but is null");
        }
        if (resultAdapter == null) {
            throw new NullPointerException("resultAdapter is marked non-null but is null");
        }
        if (resultAdapter.getSpecification().isSingular()) {
            return resultAdapter;
        }
        Object pojo = _NullSafe.streamAutodetect((Object)resultAdapter.getPojo()).findFirst().orElseThrow(_Exceptions::noSuchElement);
        ManagedObject scalarAdapter = commonContext.getObjectManager().adapt(pojo);
        return scalarAdapter;
    }

    private static TypeAndAdapter determineFor(ManagedObject resultAdapter, ActionResultResponseType mapAbsentResultTo, AjaxRequestTarget targetIfAny) {
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)resultAdapter)) {
            return TypeAndAdapter.of(mapAbsentResultTo, resultAdapter);
        }
        ObjectSpecification resultSpec = resultAdapter.getSpecification();
        if (!(resultAdapter instanceof PackedManagedObject)) {
            _Assert.assertTrue((boolean)resultSpec.isSingular());
            if ("causeway.security.LoginRedirect".equals(resultSpec.getLogicalTypeName())) {
                return TypeAndAdapter.of(SIGN_IN, resultAdapter);
            }
            if (resultSpec.isValue()) {
                Object value = resultAdapter.getPojo();
                if (value instanceof Clob) {
                    return TypeAndAdapter.of(VALUE_CLOB, resultAdapter);
                }
                if (value instanceof Blob) {
                    return TypeAndAdapter.of(VALUE_BLOB, resultAdapter);
                }
                if (value instanceof LocalResourcePath) {
                    return targetIfAny != null ? TypeAndAdapter.of(VALUE_LOCALRESPATH_AJAX, resultAdapter) : TypeAndAdapter.of(VALUE_LOCALRESPATH_NOAJAX, resultAdapter);
                }
                if (value instanceof URL) {
                    return targetIfAny != null ? TypeAndAdapter.of(VALUE_URL_AJAX, resultAdapter) : TypeAndAdapter.of(VALUE_URL_NOAJAX, resultAdapter);
                }
                return TypeAndAdapter.of(VALUE, resultAdapter);
            }
            return TypeAndAdapter.of(OBJECT, resultAdapter);
        }
        PackedManagedObject packedAdapter = (PackedManagedObject)resultAdapter;
        Can unpacked = packedAdapter.unpack();
        int cardinality = unpacked.size();
        switch (cardinality) {
            case 1: {
                ManagedObject firstElement = (ManagedObject)unpacked.getFirstElseFail();
                return ActionResultResponseType.determineFor(firstElement, VOID_AS_EMPTY, targetIfAny);
            }
        }
        return TypeAndAdapter.of(COLLECTION, resultAdapter);
    }

    private static final class TypeAndAdapter {
        private final ActionResultResponseType type;
        private final ManagedObject resultAdapter;

        @Generated
        private TypeAndAdapter(ActionResultResponseType type, ManagedObject resultAdapter) {
            this.type = type;
            this.resultAdapter = resultAdapter;
        }

        @Generated
        public static TypeAndAdapter of(ActionResultResponseType type, ManagedObject resultAdapter) {
            return new TypeAndAdapter(type, resultAdapter);
        }

        @Generated
        public ActionResultResponseType getType() {
            return this.type;
        }

        @Generated
        public ManagedObject getResultAdapter() {
            return this.resultAdapter;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeAndAdapter)) {
                return false;
            }
            TypeAndAdapter other = (TypeAndAdapter)o;
            ActionResultResponseType this$type = this.getType();
            ActionResultResponseType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            ManagedObject this$resultAdapter = this.getResultAdapter();
            ManagedObject other$resultAdapter = other.getResultAdapter();
            return !(this$resultAdapter == null ? other$resultAdapter != null : !this$resultAdapter.equals(other$resultAdapter));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ActionResultResponseType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            ManagedObject $resultAdapter = this.getResultAdapter();
            result = result * 59 + ($resultAdapter == null ? 43 : $resultAdapter.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ActionResultResponseType.TypeAndAdapter(type=" + this.getType() + ", resultAdapter=" + this.getResultAdapter() + ")";
        }
    }
}

