/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.actionresponse;

import lombok.Generated;
import lombok.NonNull;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.springframework.lang.Nullable;

public class PageRedirectRequest<T extends IRequestablePage> {
    @NonNull
    private final Class<T> pageClass;
    @Nullable
    private final PageParameters pageParameters;
    @Nullable
    private final IRequestablePage pageInstance;

    public static <T extends IRequestablePage> PageRedirectRequest<T> forPageClass(@NonNull Class<T> pageClass, @NonNull PageParameters pageParameters) {
        if (pageClass == null) {
            throw new NullPointerException("pageClass is marked non-null but is null");
        }
        if (pageParameters == null) {
            throw new NullPointerException("pageParameters is marked non-null but is null");
        }
        return new PageRedirectRequest<T>(pageClass, pageParameters, null);
    }

    public static <T extends IRequestablePage> PageRedirectRequest<T> forPageClass(@NonNull Class<T> pageClass) {
        if (pageClass == null) {
            throw new NullPointerException("pageClass is marked non-null but is null");
        }
        return new PageRedirectRequest<T>(pageClass, null, null);
    }

    public static <T extends IRequestablePage> PageRedirectRequest<T> forPage(@NonNull Class<T> pageClass, @NonNull T pageInstance) {
        if (pageClass == null) {
            throw new NullPointerException("pageClass is marked non-null but is null");
        }
        if (pageInstance == null) {
            throw new NullPointerException("pageInstance is marked non-null but is null");
        }
        return new PageRedirectRequest<T>(pageClass, null, pageInstance);
    }

    public void applyTo(@Nullable RequestCycle requestCycle) {
        if (requestCycle == null) {
            return;
        }
        if (this.pageParameters != null) {
            requestCycle.setResponsePage(this.pageClass, this.pageParameters);
            return;
        }
        if (this.pageInstance != null) {
            requestCycle.setResponsePage(this.pageInstance);
            return;
        }
        requestCycle.setResponsePage(this.pageClass);
    }

    public String toString() {
        return String.format("PageRedirectRequest[pageClass=%s,pageParameters=%s]", this.pageClass.getName(), this.pageParameters);
    }

    @Generated
    private PageRedirectRequest(@NonNull Class<T> pageClass, @Nullable PageParameters pageParameters, @Nullable IRequestablePage pageInstance) {
        if (pageClass == null) {
            throw new NullPointerException("pageClass is marked non-null but is null");
        }
        this.pageClass = pageClass;
        this.pageParameters = pageParameters;
        this.pageInstance = pageInstance;
    }
}

