/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.actionmenu.entityactions;

import java.util.function.Function;
import lombok.NonNull;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.viewer.wicket.model.links.ActionLinkUiComponentFactoryWkt;
import org.apache.causeway.viewer.wicket.model.links.LinkAndLabel;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.ActionModelImpl;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModelParented;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.model.models.ScalarParameterModel;
import org.apache.causeway.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.components.widgets.linkandlabel.ActionLink;

@FunctionalInterface
public interface LinkAndLabelFactory
extends Function<ObjectAction, LinkAndLabel> {
    public static LinkAndLabelFactory forMenu(UiObjectWkt serviceModel) {
        return action -> LinkAndLabel.of((ActionModel)ActionModelImpl.forEntity((UiObjectWkt)serviceModel, (Identifier)action.getFeatureIdentifier(), (Where)Where.ANYWHERE, null, null, null), (ActionLinkUiComponentFactoryWkt)new MenuLinkFactory());
    }

    public static LinkAndLabelFactory forEntity(UiObjectWkt parentEntityModel) {
        LinkAndLabelFactory.guardAgainstNotBookmarkable(parentEntityModel.getBookmarkedOwner());
        return action -> LinkAndLabel.of((ActionModel)ActionModelImpl.forEntity((UiObjectWkt)parentEntityModel, (Identifier)action.getFeatureIdentifier(), (Where)Where.OBJECT_FORMS, null, null, null), (ActionLinkUiComponentFactoryWkt)new AdditionalLinkFactory());
    }

    public static LinkAndLabelFactory forCollection(EntityCollectionModelParented collectionModel) {
        return action -> LinkAndLabel.of((ActionModel)ActionModelImpl.forEntity((UiObjectWkt)collectionModel.getEntityModel(), (Identifier)action.getFeatureIdentifier(), (Where)Where.OBJECT_FORMS, null, null, (EntityCollectionModel)collectionModel), (ActionLinkUiComponentFactoryWkt)new AdditionalLinkFactory());
    }

    public static LinkAndLabelFactory forPropertyOrParameter(ScalarModel scalarModel) {
        return scalarModel instanceof ScalarPropertyModel ? LinkAndLabelFactory.forProperty((ScalarPropertyModel)scalarModel) : LinkAndLabelFactory.forParameter((ScalarParameterModel)scalarModel);
    }

    public static LinkAndLabelFactory forProperty(ScalarPropertyModel propertyModel) {
        return action -> LinkAndLabel.of((ActionModel)ActionModelImpl.forEntity((UiObjectWkt)propertyModel.getParentUiModel(), (Identifier)action.getFeatureIdentifier(), (Where)Where.OBJECT_FORMS, (ScalarPropertyModel)propertyModel, null, null), (ActionLinkUiComponentFactoryWkt)new AdditionalLinkFactory());
    }

    public static LinkAndLabelFactory forParameter(ScalarParameterModel parameterModel) {
        ObjectActionParameter param = parameterModel.getMetaModel();
        if (param.isSingular() && param.getElementType().isCompositeValue()) {
            return action -> LinkAndLabel.of((ActionModel)ActionModelImpl.forEntity((UiObjectWkt)parameterModel.getParentUiModel(), (Identifier)action.getFeatureIdentifier(), (Where)Where.OBJECT_FORMS, null, (ScalarParameterModel)parameterModel, null), (ActionLinkUiComponentFactoryWkt)new AdditionalLinkFactory());
        }
        return action -> null;
    }

    private static void guardAgainstNotBookmarkable(ManagedObject objectAdapter) {
        boolean isIdentifiable = ManagedObjects.isIdentifiable((ManagedObject)objectAdapter);
        if (!isIdentifiable) {
            throw new IllegalArgumentException(String.format("Object '%s' is not identifiable (has no identifier).", objectAdapter.getTitle()));
        }
    }

    public static class AdditionalLinkFactory
    implements ActionLinkUiComponentFactoryWkt {
        private static final long serialVersionUID = 1L;

        public ActionLink newActionLinkUiComponent(@NonNull ActionModel actionModel) {
            if (actionModel == null) {
                throw new NullPointerException("actionModel is marked non-null but is null");
            }
            return ActionLink.create("additionalLink", actionModel);
        }
    }

    public static class MenuLinkFactory
    implements ActionLinkUiComponentFactoryWkt {
        private static final long serialVersionUID = 1L;

        public ActionLink newActionLinkUiComponent(@NonNull ActionModel actionModel) {
            if (actionModel == null) {
                throw new NullPointerException("actionModel is marked non-null but is null");
            }
            return ActionLink.create("menuLink", actionModel);
        }
    }
}

