/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.actionpromptsb;

import org.apache.causeway.viewer.wicket.model.models.ActionPromptWithExtraContent;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.GenericPanel;

public class ActionPromptSidebar
extends GenericPanel<Void>
implements ActionPromptWithExtraContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_HEADER = "header";
    private static final String ID_ACTION_PROMPT = "actionPrompt";
    private static final String ID_EXTRA_CONTENT = "extraContent";

    public ActionPromptSidebar(String id) {
        super(id);
        this.setOutputMarkupId(true);
        this.setOutputMarkupPlaceholderTag(true);
        Wkt.labelAdd((MarkupContainer)this, this.getTitleId(), "(no action)");
        this.add(new Component[]{new WebMarkupContainer(this.getContentId())});
        this.add(new Component[]{new WebMarkupContainer(this.getExtraContentId())});
    }

    public static ActionPromptSidebar newSidebar(String id) {
        return new ActionPromptSidebar(id);
    }

    public String getTitleId() {
        return ID_HEADER;
    }

    public String getContentId() {
        return ID_ACTION_PROMPT;
    }

    public String getExtraContentId() {
        return ID_EXTRA_CONTENT;
    }

    public void setTitle(Component titleComponent, AjaxRequestTarget target) {
        titleComponent.setMarkupId(this.getTitleId());
        this.addOrReplace(new Component[]{titleComponent});
    }

    public void setPanel(Component contentComponent, AjaxRequestTarget target) {
        contentComponent.setMarkupId(this.getContentId());
        this.addOrReplace(new Component[]{contentComponent});
    }

    public void setExtraContentPanel(Component extraContentComponent, AjaxRequestTarget target) {
        extraContentComponent.setMarkupId(this.getExtraContentId());
        this.addOrReplace(new Component[]{extraContentComponent});
    }

    public void showPrompt(AjaxRequestTarget target) {
        this.setVisible(true);
        this.show(target);
        target.add(new Component[]{this});
        Wkt.javaScriptAdd(target, Wkt.EventTopic.FOCUS_FIRST_PARAMETER, this.getMarkupId());
    }

    public void closePrompt(AjaxRequestTarget target) {
        this.setVisible(false);
        this.addOrReplace(new Component[]{new WebMarkupContainer(this.getExtraContentId())});
        if (target != null) {
            this.hide(target);
        }
    }

    private void show(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)"$('#wrapper').removeClass('toggled')");
    }

    private void hide(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)"$('#wrapper').addClass('toggled')");
    }
}

