/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table.filter;

import java.io.Serializable;
import lombok.Generated;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.wicket.ui.components.table.DataTableWithPagesAndFilter;
import org.apache.causeway.viewer.wicket.ui.components.table.internal._TableUtils;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class FilterToolbar
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String ID_TABLE_SEARCH_INPUT = "table-search-input";
    private final DataTableWithPagesAndFilter<?, ?> table;

    public FilterToolbar(String id, DataTableWithPagesAndFilter<?, ?> table) {
        super(id);
        this.table = table;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.buildGui();
        this.setVisible(this.getTable().getRowCount() > 1L);
    }

    private void buildGui() {
        DataTableInteractive dataTableInteractive = _TableUtils.interactive(this.table);
        final TextField searchField = new TextField(ID_TABLE_SEARCH_INPUT, (IModel)Model.of((Serializable)((Object)((String)dataTableInteractive.getSearchArgument().getValue()))));
        Wkt.attributeReplace(searchField, "placeholder", dataTableInteractive.getSearchPromptPlaceholderText());
        searchField.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                FilterToolbar.this.table.setSearchArg(searchField.getValue());
                FilterToolbar.this.table.setSearchHintAndBroadcast(target);
                target.add(new Component[]{FilterToolbar.this.table});
            }
        }});
        this.addOrReplace(new Component[]{searchField});
    }

    @Generated
    public DataTableWithPagesAndFilter<?, ?> getTable() {
        return this.table;
    }
}

