/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table.head;

import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.causeway.viewer.wicket.ui.components.table.DataTableWithPagesAndFilter;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.sort.AjaxFallbackOrderByBorder;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;

class OrderByBorder<T>
extends AjaxFallbackOrderByBorder<T> {
    private static final long serialVersionUID = 1L;
    private final T sortProperty;
    private final DataTableWithPagesAndFilter<?, ?> dataTable;
    private final ISortStateLocator<T> stateLocator;

    public OrderByBorder(String id, DataTableWithPagesAndFilter<?, ?> dataTable, T sortProperty, ISortStateLocator<T> stateLocator) {
        super(id, sortProperty, stateLocator);
        this.dataTable = dataTable;
        this.stateLocator = stateLocator;
        this.sortProperty = sortProperty;
    }

    protected void onAjaxClick(AjaxRequestTarget target) {
        target.add(new Component[]{this.dataTable});
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        ISortState state = this.stateLocator.getSortState();
        SortOrder order = state.getPropertySortOrder(this.sortProperty);
        this.dataTable.setSortOrderHintAndBroadcast(order, this.sortProperty.toString(), target);
        this.dataTable.setPageNumberHintAndBroadcast(target);
    }

    protected void onSortChanged() {
        super.onSortChanged();
        this.dataTable.setCurrentPage(0L);
    }

    private UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf(this.dataTable);
    }
}

