/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.tree;

import org.apache.causeway.applib.graph.tree.TreeNode;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ComponentFactoryScalarAbstract;
import org.apache.causeway.viewer.wicket.ui.components.tree.ParentedTreePanel;
import org.apache.causeway.viewer.wicket.ui.components.tree.StandaloneTreePanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class TreePanelFactories {
    public static ComponentFactory parented() {
        return new Parented();
    }

    public static ComponentFactory standalone() {
        return new Standalone();
    }

    static class Parented
    extends ComponentFactoryScalarAbstract {
        public Parented() {
            super(ParentedTreePanel.class);
        }

        @Override
        protected Component createComponent(String id, ScalarModel scalarModel) {
            return new ParentedTreePanel(id, scalarModel);
        }

        @Override
        protected ComponentFactory.ApplicationAdvice appliesTo(ScalarModel scalarModel) {
            if (!scalarModel.isScalarTypeSubtypeOf(TreeNode.class)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            return this.appliesIf(!scalarModel.hasChoices());
        }
    }

    static class Standalone
    extends ComponentFactoryAbstract {
        public Standalone() {
            super(UiComponentType.VALUE, StandaloneTreePanel.class);
        }

        @Override
        public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
            if (!(model instanceof ValueModel)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            ValueModel valueModel = (ValueModel)model;
            ManagedObject adapter = (ManagedObject)valueModel.getObject();
            if (adapter == null || adapter.getPojo() == null) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            return this.appliesIf(adapter.getPojo() instanceof TreeNode);
        }

        @Override
        public final Component createComponent(String id, IModel<?> model) {
            return new StandaloneTreePanel(id, (ValueModel)model);
        }
    }
}

