/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.widgets.themepicker;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.ActiveThemeProvider;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.SessionThemeProvider;
import de.agilecoders.wicket.core.settings.SingleThemeProvider;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.themes.markup.html.bootstrap.BootstrapThemeTheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchTheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchThemeProvider;
import java.io.Serializable;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.causeway.viewer.wicket.ui.components.widgets.themepicker.CausewayWicketThemeSupport;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.cookies.CookieUtils;
import org.apache.wicket.util.string.Strings;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class ThemeChooser
extends PanelAbstract<Void, IModel<Void>> {
    private static final long serialVersionUID = 1L;
    @Inject
    private transient CausewayWicketThemeSupport themeSupport;
    private static final String CAUSEWAY_THEME_COOKIE_NAME = "causeway.viewer.wicket.themes.selected";

    public ThemeChooser(String id) {
        super(id);
    }

    protected void onInitialize() {
        ActiveThemeProvider activeThemeProvider;
        super.onInitialize();
        if (this.getThemeSupport() == null) {
            super.getMetaModelContext().injectServicesInto((Object)this);
        }
        if ((activeThemeProvider = this.getActiveThemeProvider()).getClass() == SessionThemeProvider.class) {
            this.initializeActiveThemeFromCookie();
        }
        Wkt.listViewAdd((MarkupContainer)this, "themes", this.getThemeSupport().getEnabledThemeNames(), (SerializableConsumer & Serializable)item -> {
            String themeName = (String)item.getModelObject();
            if (themeName.equals(this.getActiveThemeProvider().getActiveTheme().name())) {
                item.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"active"))});
            }
            Wkt.add((MarkupContainer)item, Wkt.link("themeLink", (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
                this.setActiveTheme(themeName);
                this.saveActiveThemeToCookie(themeName);
                target.add(new Component[]{this.getPage()});
            }).setBody((IModel)Model.of((Serializable)((Object)themeName))));
        });
    }

    private void saveActiveThemeToCookie(String themeName) {
        CookieUtils cookieUtils = new CookieUtils();
        cookieUtils.save(CAUSEWAY_THEME_COOKIE_NAME, themeName);
    }

    private void initializeActiveThemeFromCookie() {
        boolean isAvailable;
        CookieUtils cookieUtils = new CookieUtils();
        String activeTheme = cookieUtils.load(CAUSEWAY_THEME_COOKIE_NAME);
        if (!Strings.isEmpty((String)activeTheme) && (isAvailable = this.getThemeSupport().getThemeProvider().available().stream().anyMatch(theme -> activeTheme.equals(theme.name())))) {
            this.setActiveTheme(activeTheme);
        }
    }

    private void setActiveTheme(String activeTheme) {
        IBootstrapSettings bootstrapSettings = Bootstrap.getSettings();
        ITheme theme = this.getThemeSupport().getThemeProvider().byName(activeTheme);
        this.getActiveThemeProvider().setActiveTheme(theme);
        if (theme instanceof BootstrapThemeTheme) {
            bootstrapSettings.setThemeProvider((ThemeProvider)new SingleThemeProvider(theme));
        } else if (theme instanceof BootswatchTheme) {
            bootstrapSettings.setThemeProvider((ThemeProvider)new BootswatchThemeProvider((BootswatchTheme)theme));
        }
    }

    private ActiveThemeProvider getActiveThemeProvider() {
        return Bootstrap.getSettings().getActiveThemeProvider();
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setName("li");
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"dropdown"});
    }

    protected void onConfigure() {
        super.onConfigure();
        boolean shouldShow = this.getWicketViewerSettings().getThemes().isShowChooser();
        this.setVisible(shouldShow);
    }

    @Generated
    public CausewayWicketThemeSupport getThemeSupport() {
        return this.themeSupport;
    }
}

