/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.errors;

import lombok.Generated;
import org.apache.causeway.commons.internal.base._Text;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.services.message.MessageBroker;
import org.apache.wicket.util.string.Strings;

public final class JGrowlUtil {
    public static String asJGrowlCalls(MessageBroker messageBroker, CausewayConfiguration configuration) {
        StringBuilder buf = new StringBuilder();
        CausewayConfiguration.Viewer.Wicket.MessagePopups messagePopupConfig = configuration.getViewer().getWicket().getMessagePopups();
        for (String info : messageBroker.drainMessages()) {
            JGrowlUtil.addJGrowlCall(info, MessageSeverity.INFO, messagePopupConfig, buf);
        }
        for (String warning : messageBroker.drainWarnings()) {
            JGrowlUtil.addJGrowlCall(warning, MessageSeverity.WARNING, messagePopupConfig, buf);
        }
        messageBroker.drainApplicationError().ifPresent(error -> JGrowlUtil.addJGrowlCall(error, MessageSeverity.DANGER, messagePopupConfig, buf));
        return buf.toString();
    }

    private static void addJGrowlCall(String origMsg, MessageSeverity severity, CausewayConfiguration.Viewer.Wicket.MessagePopups messagePopups, StringBuilder buf) {
        String escapedMsg = JGrowlUtil.escape(origMsg);
        buf.append("$.growl(\"").append((CharSequence)escapedMsg).append('\"');
        buf.append(", {");
        buf.append("type: \"").append(severity.cssClassSuffix()).append('\"');
        buf.append(String.format(", delay: %d", severity.delayMillis(messagePopups)));
        buf.append(String.format(", placement: { from: '%s', align: '%s' }", messagePopups.getPlacement().getVertical().name().toLowerCase(), messagePopups.getPlacement().getHorizontal().name().toLowerCase()));
        buf.append(String.format(", offset: %d", messagePopups.getOffset()));
        buf.append('}');
        buf.append(");\n");
    }

    public static String escape(String origMsg) {
        _Text.normalize((String)origMsg);
        String escaped = Strings.escapeMarkup((CharSequence)origMsg).toString();
        return escaped.replace("&quot;", "'").replace("&#039;", "'").replace("\r", "").replace("\t", " ").replace("\n", "<br/>");
    }

    @Generated
    private JGrowlUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static enum MessageSeverity {
        INFO{

            @Override
            long delayMillis(CausewayConfiguration.Viewer.Wicket.MessagePopups messagePopups) {
                return messagePopups.getInfoDelay().toMillis();
            }
        }
        ,
        WARNING{

            @Override
            long delayMillis(CausewayConfiguration.Viewer.Wicket.MessagePopups messagePopups) {
                return messagePopups.getWarningDelay().toMillis();
            }
        }
        ,
        DANGER{

            @Override
            long delayMillis(CausewayConfiguration.Viewer.Wicket.MessagePopups messagePopups) {
                return messagePopups.getErrorDelay().toMillis();
            }
        };


        public String cssClassSuffix() {
            return this.name().toLowerCase();
        }

        abstract long delayMillis(CausewayConfiguration.Viewer.Wicket.MessagePopups var1);
    }
}

