/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages.entity;

import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.publishing.spi.PageRenderSubscriber;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.debug._Debug;
import org.apache.causeway.commons.internal.debug.xray.XrayUi;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.object.Bookmarkable;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.causeway.viewer.wicket.model.modelhelpers.WhereAmIHelper;
import org.apache.causeway.viewer.wicket.model.models.BookmarkableModel;
import org.apache.causeway.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.causeway.viewer.wicket.ui.components.entity.icontitle.EntityIconAndTitlePanel;
import org.apache.causeway.viewer.wicket.ui.pages.PageAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

@AuthorizeInstantiation(value={"org.apache.causeway.security.AUTHORIZED_USER_ROLE"})
public class EntityPage
extends PageAbstract {
    private static final long serialVersionUID = 144368606134796079L;
    private static final CssResourceReference ENTITY_PAGE_CSS = new CssResourceReference(EntityPage.class, "EntityPage.css");
    private final UiObjectWkt model;

    public static EntityPage forPageParameters(PageParameters pageParameters) {
        _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> _Debug.log((String)"new EntityPage from PageParameters %s", (Object[])new Object[]{pageParameters}));
        Optional bookmark = PageParameterUtils.toBookmark((PageParameters)pageParameters);
        if (!bookmark.isPresent()) {
            throw new RestartResponseException(Application.get().getHomePage());
        }
        return new EntityPage(pageParameters, UiObjectWkt.ofPageParameters((PageParameters)pageParameters));
    }

    public static EntityPage forAdapter(ManagedObject adapter) {
        _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> _Debug.log((String)"new EntityPage from Adapter %s", (Object[])new Object[]{adapter.getSpecification()}));
        return new EntityPage(PageParameterUtils.createPageParametersForObject((ManagedObject)adapter), UiObjectWkt.ofAdapter((ManagedObject)adapter));
    }

    private EntityPage(PageParameters pageParameters, UiObjectWkt entityModel) {
        super(pageParameters, null, UiComponentType.ENTITY);
        this.model = entityModel;
    }

    protected void onInitialize() {
        this.buildPage();
        super.onInitialize();
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)ENTITY_PAGE_CSS));
    }

    @Override
    public UiHintContainer getUiHintContainerIfAny() {
        return this.model;
    }

    private void buildPage() {
        ManagedObject objectAdapter;
        try {
            objectAdapter = (ManagedObject)this.model.getObject();
        }
        catch (RuntimeException ex) {
            this.removeAnyBookmark(this.model);
            this.removeAnyBreadcrumb(this.model);
            throw new ObjectMember.AuthorizationException(ex);
        }
        if (!this.model.isVisible()) {
            throw new ObjectMember.AuthorizationException();
        }
        ObjectSpecification objectSpec = this.model.getTypeOfSpecification();
        Facets.gridPreload((ObjectSpecification)objectSpec, (ManagedObject)objectAdapter);
        String titleStr = objectAdapter.getTitle();
        this.setTitle(titleStr);
        WebMarkupContainer entityPageContainer = new WebMarkupContainer("entityPageContainer");
        Wkt.cssAppend(entityPageContainer, objectSpec.getFeatureIdentifier());
        Facets.cssClass((FacetHolder)objectSpec, (ManagedObject)objectAdapter).ifPresent(cssClass -> Wkt.cssAppend(entityPageContainer, cssClass));
        this.themeDiv.addOrReplace(new Component[]{entityPageContainer});
        this.addWhereAmIIfShown(entityPageContainer, WhereAmIHelper.of((UiObjectWkt)this.model));
        this.bookmarkPageIfShown((BookmarkableModel)this.model);
        this.addBreadcrumbIfShown(this.model);
        this.addBookmarkedPages((MarkupContainer)entityPageContainer);
        Try.run(() -> this.addChildComponents((MarkupContainer)entityPageContainer, (IModel<?>)this.model)).ifFailure(__ -> Wkt.add((MarkupContainer)entityPageContainer, new EmptyPanel("entity"))).ifFailureFail();
    }

    protected void addWhereAmIIfShown(WebMarkupContainer entityPageContainer, WhereAmIHelper whereAmIModel) {
        WebMarkupContainer whereAmIContainer = new WebMarkupContainer("whereAmI-container");
        entityPageContainer.addOrReplace(new Component[]{whereAmIContainer});
        if (!whereAmIModel.isShowWhereAmI()) {
            whereAmIContainer.setVisible(false);
            return;
        }
        RepeatingView listItems = new RepeatingView("whereAmI-items");
        whereAmIModel.streamParentChainReversed().forEach(entityModel -> listItems.add(new Component[]{new EntityIconAndTitlePanel(listItems.newChildId(), (ObjectAdapterModel)entityModel)}));
        Wkt.labelAdd((MarkupContainer)listItems, listItems.newChildId(), whereAmIModel.getStartOfChain().getTitle());
        whereAmIContainer.addOrReplace(new Component[]{listItems});
    }

    @Override
    public void onNewRequestCycle() {
        UiObjectWkt entityModel = (UiObjectWkt)this.getUiHintContainerIfAny();
        ManagedObjects.refreshViewmodel((ManagedObject)((ManagedObject)entityModel.getObject()), () -> (Bookmark)PageParameterUtils.toBookmark((PageParameters)this.getPageParameters()).orElseThrow());
    }

    @Override
    public void onRendering(Can<PageRenderSubscriber> pageRenderSubscribers) {
        this.onRenderingOrRendered(pageRenderSubscribers, (pageRenderSubscriber, bookmark) -> {
            pageRenderSubscriber.onRenderingDomainObject(bookmark);
            return null;
        });
    }

    @Override
    public void onRendered(Can<PageRenderSubscriber> pageRenderSubscribers) {
        this.onRenderingOrRendered(pageRenderSubscribers, (pageRenderSubscriber, bookmark) -> {
            pageRenderSubscriber.onRenderedDomainObject(bookmark);
            return null;
        });
    }

    private void onRenderingOrRendered(Can<PageRenderSubscriber> pageRenderSubscribers, BiFunction<PageRenderSubscriber, Bookmark, Void> handler) {
        if (pageRenderSubscribers.isEmpty()) {
            return;
        }
        ManagedObjects.asSpecified((ManagedObject)((ManagedObject)this.model.getObject())).map(Bookmarkable::getBookmark).filter(Optional::isPresent).map(Optional::get).ifPresent(bookmark -> pageRenderSubscribers.forEach(pageRenderSubscriber -> handler.apply((PageRenderSubscriber)pageRenderSubscriber, (Bookmark)bookmark)));
    }

    private void addBreadcrumbIfShown(UiObjectWkt entityModel) {
        this.getBreadcrumbModel().ifPresent(breadcrumbModel -> breadcrumbModel.visited(entityModel));
    }

    private void removeAnyBreadcrumb(UiObjectWkt entityModel) {
        this.getBreadcrumbModel().ifPresent(breadcrumbModel -> breadcrumbModel.remove(entityModel));
    }
}

