/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.entity.collection;

import java.io.Serializable;
import lombok.NonNull;
import org.apache.causeway.applib.layout.component.CollectionLayoutData;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.entity.EntityComponentFactoryAbstract;
import org.apache.causeway.viewer.wicket.ui.components.entity.collection.EntityCollectionPanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class EntityCollectionPanelFactory
extends EntityComponentFactoryAbstract {
    public EntityCollectionPanelFactory() {
        super(UiComponentType.ENTITY_COLLECTION, EntityCollectionPanel.class);
    }

    @Override
    protected ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        if (!(model instanceof Model)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        return model.getObject() instanceof CollectionOwnerAndLayout ? ComponentFactory.ApplicationAdvice.APPLIES : ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
    }

    @Override
    public Component createComponent(String id, IModel<?> model) {
        CollectionOwnerAndLayout collectionOwnerAndId = (CollectionOwnerAndLayout)model.getObject();
        return new EntityCollectionPanel(id, collectionOwnerAndId.getOwner(), collectionOwnerAndId.getLayout());
    }

    public static class CollectionOwnerAndLayout
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @NonNull
        final UiObjectWkt owner;
        @NonNull
        final CollectionLayoutData layout;

        public CollectionOwnerAndLayout(@NonNull UiObjectWkt owner, @NonNull CollectionLayoutData layout) {
            if (owner == null) {
                throw new NullPointerException("owner is marked non-null but is null");
            }
            if (layout == null) {
                throw new NullPointerException("layout is marked non-null but is null");
            }
            this.owner = owner;
            this.layout = layout;
        }

        @NonNull
        public UiObjectWkt getOwner() {
            return this.owner;
        }

        @NonNull
        public CollectionLayoutData getLayout() {
            return this.layout;
        }
    }
}

