/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.scalars;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelAbstract2;
import org.apache.causeway.viewer.wicket.ui.components.scalars._Util;
import org.apache.causeway.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.causeway.viewer.wicket.ui.util.XrayWkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.springframework.lang.Nullable;

public abstract class ScalarPanelFormFieldAbstract<T>
extends ScalarPanelAbstract2 {
    private static final long serialVersionUID = 1L;
    protected final Class<T> type;
    private FormComponent<T> formComponent;

    protected ScalarPanelFormFieldAbstract(String id, ScalarModel scalarModel, Class<T> type) {
        super(id, scalarModel);
        this.type = type;
    }

    @Override
    protected final Component getValidationFeedbackReceiver() {
        return this.getFormComponent();
    }

    protected MarkupContainer createFieldFrame() {
        ScalarPanelAbstract.RenderScenario renderScenario = this.getRenderScenario();
        ScalarFragmentFactory.FieldFragment fieldFragment = switch (renderScenario) {
            case ScalarPanelAbstract.RenderScenario.READONLY -> ScalarFragmentFactory.FieldFragment.NO_LINK_VIEWING;
            case ScalarPanelAbstract.RenderScenario.CAN_EDIT, ScalarPanelAbstract.RenderScenario.CAN_EDIT_INLINE, ScalarPanelAbstract.RenderScenario.CAN_EDIT_INLINE_VIA_ACTION, ScalarPanelAbstract.RenderScenario.EDITING_WITH_LINK_TO_NESTED -> ScalarFragmentFactory.FieldFragment.LINK_TO_PROMT;
            case ScalarPanelAbstract.RenderScenario.EDITING -> this.scalarModel().isEditingMode() ? ScalarFragmentFactory.FieldFragment.NO_LINK_EDITING : ScalarFragmentFactory.FieldFragment.NO_LINK_VIEWING;
            default -> throw _Exceptions.unmatchedCase((Object)((Object)renderScenario));
        };
        return Wkt.fragment(fieldFragment.getContainerId(), fieldFragment.getFragmentId(), (MarkupContainer)this);
    }

    @Nullable
    protected final FormComponent<T> getFormComponent() {
        return this.formComponent;
    }

    protected abstract FormComponent<T> createFormComponent(String var1, ScalarModel var2);

    @Override
    protected final MarkupContainer createRegularFrame() {
        ScalarModel scalarModel = this.scalarModel();
        Model friendlyNameModel = Model.of((Serializable)((Object)scalarModel.getFriendlyName()));
        this.formComponent = this.createFormComponent("scalarValue", scalarModel);
        this.formComponent.setLabel((IModel)friendlyNameModel);
        FormGroup formGroup = ScalarFragmentFactory.FrameFragment.REGULAR.createComponent(id -> new FormGroup((String)id, this.formComponent));
        formGroup.add(new Component[]{this.formComponent});
        Component[] componentArray = new Component[1];
        this.fieldFrame = this.createFieldFrame();
        componentArray[0] = this.fieldFrame;
        formGroup.add(componentArray);
        this.formComponent.setRequired(scalarModel.isRequired());
        if (scalarModel.isShowMandatoryIndicator()) {
            Wkt.cssAppend(formGroup, "mandatory");
        }
        this.scalarNameLabelAddTo((MarkupContainer)formGroup, (IModel<String>)friendlyNameModel);
        this.formComponent.add(_Util.createValidatorFor(scalarModel));
        ScalarPanelAbstract.RenderScenario renderScenario = this.getRenderScenario();
        XrayWkt.ifEnabledDo(() -> {
            LinkedHashMap xrayDetails = _Maps.newLinkedHashMap();
            xrayDetails.put("panel", this.getClass().getSimpleName());
            xrayDetails.put("renderScenario", renderScenario.name());
            xrayDetails.put("inputFragmentType", this.getInputFragmentType().map(x -> x.name()).orElse("(none)"));
            xrayDetails.put("formComponent", _Strings.nonEmpty((CharSequence)this.formComponent.getClass().getSimpleName()).orElseGet(() -> this.formComponent.getClass().getName()));
            xrayDetails.put("formComponent.id", this.formComponent.getId());
            xrayDetails.put("formComponent.validators (count)", "" + _NullSafe.size((Collection)this.formComponent.getValidators()));
            xrayDetails.put("scalarModel.disableReason", "" + this.scalarModel().disabledReason().map(InteractionVeto::getReason).orElse(null));
            xrayDetails.put("scalarModel.whetherHidden", "" + this.scalarModel().whetherHidden());
            xrayDetails.put("scalarModel.identifier", this.scalarModel().getIdentifier());
            xrayDetails.put("scalarModel.choices (count)", "" + this.scalarModel().getChoices().size());
            xrayDetails.put("scalarModel.metaModel.featureIdentifier", "" + this.scalarModel().getMetaModel().getFeatureIdentifier());
            xrayDetails.put("scalarModel.scalarTypeSpec", this.scalarModel().getElementType().toString());
            xrayDetails.put("scalarModel.proposedValue", "" + this.scalarModel().proposedValue().getValue().getValue());
            Wkt.markupAdd(this.fieldFrame, "xrayDetails", XrayWkt.formatAsListGroup(xrayDetails));
        });
        if (renderScenario.isReadonly()) {
            this.fieldFrame.add(new Component[]{ScalarFragmentFactory.FieldFrame.SCALAR_VALUE_CONTAINER.createComponent(this::createComponentForOutput)});
        } else if (!renderScenario.isViewingAndCanEditAny()) {
            this.getInputFragmentType().ifPresent(inputFragmentType -> this.fieldFrame.add(new Component[]{inputFragmentType.createFragment((MarkupContainer)this, this.formComponent)}));
        }
        this.onFormGroupCreated(formGroup);
        this.formComponent.setVisible(true);
        this.formComponent.setVisibilityAllowed(true);
        return formGroup;
    }

    @Override
    protected final Component createCompactFrame() {
        return ScalarFragmentFactory.FrameFragment.COMPACT.createComponent(this::createComponentForOutput);
    }

    protected Optional<ScalarFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.empty();
    }

    protected void onFormGroupCreated(FormGroup formGroup) {
    }

    @Override
    protected void onInitializeNotEditable() {
        if (this.getFormComponent() != null) {
            this.getFormComponent().setEnabled(false);
        }
        if (this.getWicketViewerSettings().isReplaceDisabledTagWithReadonlyTag()) {
            Wkt.behaviorAddReplaceDisabledTagWithReadonlyTag(this.getFormComponent());
        }
        this.clearTooltip();
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        this.formComponentEnable(false);
        if (this.getWicketViewerSettings().isReplaceDisabledTagWithReadonlyTag()) {
            Wkt.behaviorAddReplaceDisabledTagWithReadonlyTag(this.getFormComponent());
        }
        this.setTooltip(disableReason);
    }

    @Override
    protected void onInitializeEditable() {
        this.formComponentEnable(true);
        this.clearTooltip();
    }

    @Override
    protected void onMakeNotEditable(String disableReason) {
        super.onMakeNotEditable(disableReason);
        this.formComponentEnable(false);
        this.setTooltip(disableReason);
    }

    @Override
    protected void onMakeEditable() {
        super.onMakeEditable();
        this.formComponentEnable(true);
        this.clearTooltip();
    }

    public String getVariation() {
        return XrayWkt.isEnabled() ? "xray" : super.getVariation();
    }

    private void formComponentEnable(boolean b) {
        if (this.getFormComponent() != null) {
            this.getFormComponent().setEnabled(b);
        }
        if (this.inlinePromptLink != null) {
            this.inlinePromptLink.setEnabled(b);
        }
    }

    private void setTooltip(String tooltip) {
        WktTooltips.addTooltip(this.getFormComponent(), tooltip);
        WktTooltips.addTooltip(this.inlinePromptLink, tooltip);
    }

    private void clearTooltip() {
        WktTooltips.clearTooltip(this.getFormComponent());
        WktTooltips.clearTooltip((Component)this.inlinePromptLink);
    }
}

