/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.app.registry;

import java.io.Serializable;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.services.registry.ServiceRegistry;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.ui.CollectionContentsAsFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.wicket.model.IModel;

public final class ComponentFactoryKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<? extends ComponentFactory> factoryClass;
    private final String id;
    private final String label;
    private final UiComponentType componentType;
    private int orderOfAppearanceInUiDropdown;
    private boolean isPageReloadRequiredOnTableViewActivation;
    private String cssClass;
    private transient ComponentFactory componentFactory;

    public ComponentFactoryKey(@NonNull ComponentFactory componentFactory) {
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory is marked non-null but is null");
        }
        this.factoryClass = componentFactory.getClass();
        this.componentFactory = componentFactory;
        this.id = componentFactory.getName();
        this.label = _Casts.castTo(CollectionContentsAsFactory.class, (Object)componentFactory).map(CollectionContentsAsFactory::getTitleLabel).map(IModel::getObject).orElseGet(() -> componentFactory.getName());
        this.componentType = componentFactory.getComponentType();
        this.orderOfAppearanceInUiDropdown = componentFactory instanceof CollectionContentsAsFactory ? ((CollectionContentsAsFactory)((Object)componentFactory)).orderOfAppearanceInUiDropdown() : Integer.MAX_VALUE;
        this.isPageReloadRequiredOnTableViewActivation = componentFactory instanceof CollectionContentsAsFactory ? ((CollectionContentsAsFactory)((Object)componentFactory)).isPageReloadRequiredOnTableViewActivation() : false;
        this.cssClass = _Casts.castTo(CollectionContentsAsFactory.class, (Object)componentFactory).map(CollectionContentsAsFactory::getCssClass).map(IModel::getObject).orElseGet(() -> (String)_Strings.asLowerDashed.apply((Object)componentFactory.getName()));
    }

    public ComponentFactory resolve(@NonNull Supplier<ServiceRegistry> serviceRegistrySupplier) {
        if (serviceRegistrySupplier == null) {
            throw new NullPointerException("serviceRegistrySupplier is marked non-null but is null");
        }
        return this.componentFactory != null ? this.componentFactory : (this.componentFactory = this.componentFactoryRegistry(serviceRegistrySupplier).lookupFactoryElseFail(this.factoryClass));
    }

    ComponentFactoryRegistry componentFactoryRegistry(@NonNull Supplier<ServiceRegistry> serviceRegistrySupplier) {
        if (serviceRegistrySupplier == null) {
            throw new NullPointerException("serviceRegistrySupplier is marked non-null but is null");
        }
        return (ComponentFactoryRegistry)serviceRegistrySupplier.get().lookupServiceElseFail(ComponentFactoryRegistry.class);
    }

    @Generated
    public Class<? extends ComponentFactory> factoryClass() {
        return this.factoryClass;
    }

    @Generated
    public String id() {
        return this.id;
    }

    @Generated
    public String label() {
        return this.label;
    }

    @Generated
    public UiComponentType componentType() {
        return this.componentType;
    }

    @Generated
    public int orderOfAppearanceInUiDropdown() {
        return this.orderOfAppearanceInUiDropdown;
    }

    @Generated
    public boolean isPageReloadRequiredOnTableViewActivation() {
        return this.isPageReloadRequiredOnTableViewActivation;
    }

    @Generated
    public String cssClass() {
        return this.cssClass;
    }
}

