/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModelParented;
import org.apache.causeway.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.bulk.MultiselectToggleProvider;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorPanel;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorProvider;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ToggleboxColumn;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.model.IModel;

public class CollectionPanel
extends PanelAbstract<DataTableInteractive, EntityCollectionModelParented>
implements CollectionPresentationSelectorProvider,
MultiselectToggleProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_FEEDBACK = "feedback";
    private CollectionPresentationSelectorPanel selectorDropdownPanel;
    private transient Optional<ToggleboxColumn> toggleboxColumn;

    public CollectionPanel(String id, EntityCollectionModelParented collectionModel) {
        super(id, collectionModel);
        OneToManyAssociation collMetaModel = ((EntityCollectionModelParented)this.getModel()).getMetaModel();
        Can associatedActions = (Can)collMetaModel.streamAssociatedActions().map(LinkAndLabelFactory.forCollection(collectionModel)).collect(Can.toCan());
        collectionModel.setLinkAndLabels((Iterable)associatedActions);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        Component collectionContents = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, UiComponentType.COLLECTION_CONTENTS, (IModel<?>)this.getModel());
        this.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, collectionContents, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(collectionContents))});
        this.setOutputMarkupId(true);
    }

    @Override
    public ToggleboxColumn getToggleboxColumn() {
        if (this.toggleboxColumn == null) {
            EntityCollectionModelParented collModel = (EntityCollectionModelParented)this.getModel();
            OneToManyAssociation collMetaModel = collModel.getMetaModel();
            this.toggleboxColumn = collMetaModel.hasAssociatedActionsWithChoicesFromThisCollection() ? Optional.of(new ToggleboxColumn((IModel<DataTableInteractive>)collModel.delegate())) : Optional.empty();
        }
        return this.toggleboxColumn.orElse(null);
    }

    @Override
    @Generated
    public CollectionPresentationSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }

    @Generated
    public void setSelectorDropdownPanel(CollectionPresentationSelectorPanel selectorDropdownPanel) {
        this.selectorDropdownPanel = selectorDropdownPanel;
    }
}

