/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.ui.components.collection.bulk.MultiselectToggleProvider;
import org.apache.causeway.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.AssociationColumnAbstract;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ColumnAbbreviationOptions;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericColumn;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.PluralColumn;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.SingularColumn;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.TitleColumn;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ToggleboxColumn;
import org.apache.causeway.viewer.wicket.ui.components.table.CausewayAjaxDataTable;
import org.apache.causeway.viewer.wicket.ui.components.table.filter.FilterToolbar;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class CollectionContentsAsAjaxTablePanel
extends PanelAbstract<DataTableInteractive, EntityCollectionModel>
implements CollectionCountProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_TABLE = "table";
    private static final String ID_TABLE_FILTER_BAR = "table-filter-bar";
    private static final CssResourceReference TABLE_CSS = new CssResourceReference(CollectionContentsAsAjaxTablePanel.class, "CollectionContentsAsAjaxTablePanel.css");

    public CollectionContentsAsAjaxTablePanel(String id, EntityCollectionModel model) {
        super(id, model);
    }

    @Override
    public Integer getCount() {
        return ((EntityCollectionModel)this.getModel()).getDataTableModel().getFilteredElementCount();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)TABLE_CSS));
    }

    protected void onModelChanged() {
    }

    private EntityCollectionModel entityCollectionModel() {
        return (EntityCollectionModel)this.getModel();
    }

    private DataTableInteractive dataTableInteractive() {
        return (DataTableInteractive)this.getModelObject();
    }

    private void buildGui() {
        ArrayList columns = _Lists.newArrayList();
        MultiselectToggleProvider multiselectToggleProvider = this.getMultiselectToggleProvider();
        ToggleboxColumn toggleboxColumn = multiselectToggleProvider != null ? multiselectToggleProvider.getToggleboxColumn() : null;
        EntityCollectionModel collectionModel = this.entityCollectionModel();
        this.addPropertyColumnsIfRequired(columns);
        this.prependTitleColumn(columns, collectionModel.getVariant(), this.getWicketViewerSettings());
        if (toggleboxColumn != null) {
            columns.add(0, toggleboxColumn);
        }
        CollectionContentsSortableDataProvider dataProvider = new CollectionContentsSortableDataProvider((IModel<DataTableInteractive>)collectionModel);
        CausewayAjaxDataTable dataTable = new CausewayAjaxDataTable(ID_TABLE, columns, dataProvider, collectionModel.getPageSize(), toggleboxColumn);
        this.addOrReplace(new Component[]{dataTable});
        this.addFilterToolbar(dataTable);
    }

    private MultiselectToggleProvider getMultiselectToggleProvider() {
        for (CollectionContentsAsAjaxTablePanel component = this; component != null; component = component.getParent()) {
            if (!(component instanceof MultiselectToggleProvider)) continue;
            return (MultiselectToggleProvider)((Object)component);
        }
        return null;
    }

    private void addFilterToolbar(CausewayAjaxDataTable dataTableComponent) {
        Wkt.addIfElseHide(this.dataTableInteractive().isSearchSupported(), (MarkupContainer)this, ID_TABLE_FILTER_BAR, id -> new FilterToolbar((String)id, dataTableComponent));
    }

    private void prependTitleColumn(List<GenericColumn> columns, EntityCollectionModel.Variant variant, CausewayConfiguration.Viewer.Wicket wktConfig) {
        Bookmark contextBookmark = this.entityCollectionModel().getParentObject().getBookmark().orElse(null);
        int maxColumnTitleLength = ((EntityCollectionModel)this.getModel()).getVariant().isParented() ? wktConfig.getMaxTitleLengthInParentedTables() : wktConfig.getMaxTitleLengthInStandaloneTables();
        ColumnAbbreviationOptions opts = ColumnAbbreviationOptions.builder().maxElementTitleLength(columns.size() == 0 ? wktConfig.getMaxTitleLengthInTablesNotHavingAnyPropertyColumn() : -1).build();
        columns.add(0, new TitleColumn(variant, contextBookmark, maxColumnTitleLength, opts));
    }

    private void addPropertyColumnsIfRequired(List<GenericColumn> columns) {
        EntityCollectionModel collectionModel = (EntityCollectionModel)this.getModel();
        ObjectSpecification elementTypeSpec = collectionModel.getElementType();
        if (elementTypeSpec == null) {
            return;
        }
        ManagedObject parentObject = collectionModel.getParentObject();
        Identifier memberIdentifier = collectionModel.getIdentifier();
        elementTypeSpec.streamAssociationsForColumnRendering(memberIdentifier, parentObject).map(ObjectAssociation::getSpecialization).map(spez -> (AssociationColumnAbstract)spez.fold(this::createSingularColumn, this::createPluralColumn)).forEach(columns::add);
    }

    private SingularColumn createSingularColumn(OneToOneAssociation property) {
        EntityCollectionModel collectionModel = (EntityCollectionModel)this.getModel();
        String parentTypeName = property.getDeclaringType().getLogicalTypeName();
        Optional<String> sortability = property.getElementType().isComparableOrOrdered() ? Optional.of(property.getId()) : Optional.empty();
        return new SingularColumn(collectionModel.getVariant(), (IModel<String>)Model.of((Serializable)((Object)property.getCanonicalFriendlyName())), sortability, property.getId(), parentTypeName, property.getCanonicalDescription());
    }

    private PluralColumn createPluralColumn(OneToManyAssociation collection) {
        EntityCollectionModel collectionModel = (EntityCollectionModel)this.getModel();
        String parentTypeName = collection.getDeclaringType().getLogicalTypeName();
        return new PluralColumn(collectionModel.getVariant(), (IModel<String>)Model.of((Serializable)((Object)collection.getCanonicalFriendlyName())), collection.getId(), parentTypeName, collection.getCanonicalDescription(), PluralColumn.RenderOptions.builder().build());
    }
}

