/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import lombok.NonNull;
import org.apache.causeway.applib.annotation.TableDecorator;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.facets.SingleValueFacet;
import org.apache.causeway.core.metamodel.facets.object.tabledec.TableDecoratorFacet;
import org.apache.causeway.core.metamodel.object.MmSortUtils;
import org.apache.causeway.core.metamodel.tabular.DataColumn;
import org.apache.causeway.core.metamodel.tabular.DataRow;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModelAbstract;
import org.apache.causeway.viewer.wicket.model.models.interaction.coll.DataRowWkt;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public class CollectionContentsSortableDataProvider
extends SortableDataProvider<DataRow, String> {
    private static final long serialVersionUID = 1L;
    private final IModel<DataTableInteractive> dataTableModelHolder;

    public CollectionContentsSortableDataProvider(IModel<DataTableInteractive> dataTableModelHolder) {
        this.dataTableModelHolder = dataTableModelHolder instanceof EntityCollectionModelAbstract ? ((EntityCollectionModelAbstract)dataTableModelHolder).delegate() : dataTableModelHolder;
    }

    public boolean isDecoratedWithDataTablesNet() {
        return this.getDataTableModel().getMetaModel().getFacetHolder().lookupFacet(TableDecoratorFacet.class).map(SingleValueFacet::value).map(TableDecorator.DatatablesNet.class::equals).orElse(false);
    }

    public DataTableInteractive getDataTableModel() {
        return (DataTableInteractive)this.dataTableModelHolder.getObject();
    }

    public IModel<DataRow> model(DataRow dataRow) {
        return DataRowWkt.chain(this.dataTableModelHolder, (DataRow)dataRow);
    }

    public long size() {
        return this.getDataTableModel().getFilteredElementCount();
    }

    public Iterator<DataRow> iterator(long skip, long limit) {
        DataTableInteractive dataTable = this.getDataTableModel();
        dataTable.getColumnSort().setValue((Object)this.columnSort().orElse(null));
        return ((Can)dataTable.getDataRowsFilteredAndSorted().getValue()).iterator(Math.toIntExact(skip), Math.toIntExact(limit));
    }

    private Optional<DataTableInteractive.ColumnSort> columnSort() {
        SortParam sortParam = this.getSort();
        return this.lookupColumnIndexFor((SortParam<String>)sortParam).stream().mapToObj(columnIndex -> new DataTableInteractive.ColumnSort(columnIndex, CollectionContentsSortableDataProvider.sortDirection((SortParam<String>)sortParam))).findFirst();
    }

    private OptionalInt lookupColumnIndexFor(@Nullable SortParam<String> sortParam) {
        if (sortParam == null) {
            return OptionalInt.empty();
        }
        int columnIndex = 0;
        for (DataColumn column : (Can)this.getDataTableModel().getDataColumns().getValue()) {
            if (column.getAssociationMetaModel().getId().equals(sortParam.getProperty())) {
                return OptionalInt.of(columnIndex);
            }
            ++columnIndex;
        }
        return OptionalInt.empty();
    }

    private static MmSortUtils.SortDirection sortDirection(@NonNull SortParam<String> sortParam) {
        if (sortParam == null) {
            throw new NullPointerException("sortParam is marked non-null but is null");
        }
        return sortParam.isAscending() ? MmSortUtils.SortDirection.ASCENDING : MmSortUtils.SortDirection.DESCENDING;
    }
}

