/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.property;

import java.io.Serializable;
import org.apache.causeway.core.metamodel.commons.ViewOrEditMode;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.commons.model.hints.RenderingHint;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class PropertyEditPanel
extends PanelAbstract<ManagedObject, ScalarPropertyModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_HEADER = "header";
    private static final String ID_PROPERTY_NAME = "propertyName";
    private boolean showHeader = true;

    public PropertyEditPanel(String id, ScalarPropertyModel scalarModel) {
        super(id, scalarModel.copyHaving(ViewOrEditMode.EDITING, RenderingHint.REGULAR));
        this.buildGui((ScalarModel)scalarModel);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.buildGui((ScalarModel)this.scalarModel());
    }

    private void buildGui(ScalarModel scalarModel) {
        this.buildGuiForParameters(scalarModel);
    }

    ScalarPropertyModel scalarModel() {
        return (ScalarPropertyModel)super.getModel();
    }

    public PropertyEditPanel setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
        return this;
    }

    private void buildGuiForParameters(ScalarModel scalarModel) {
        WebMarkupContainer header = this.addHeader();
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, UiComponentType.PROPERTY_EDIT_FORM, (IModel<?>)this.scalarModel());
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)header, UiComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)scalarModel.getParentUiModel());
        Wkt.labelAdd((MarkupContainer)header, ID_PROPERTY_NAME, (IModel<String>)((IModel & Serializable)() -> ((ScalarPropertyModel)this.scalarModel()).getFriendlyName())).setEscapeModelStrings(true);
    }

    private WebMarkupContainer addHeader() {
        WebMarkupContainer header = new WebMarkupContainer(ID_HEADER){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(PropertyEditPanel.this.showHeader);
            }
        };
        this.addOrReplace(new Component[]{header});
        return header;
    }
}

