/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.actionresponse;

import lombok.NonNull;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.value.OpenUrlStrategy;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.ui.actionresponse.ActionResultResponseHandlingStrategy;
import org.apache.causeway.viewer.wicket.ui.actionresponse.PageRedirectRequest;
import org.apache.causeway.viewer.wicket.ui.actionresponse._ResponseUtil;
import org.apache.causeway.viewer.wicket.ui.pages.obj.DomainObjectPage;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.IRequestHandler;
import org.springframework.lang.Nullable;

public record ActionResultResponse(ActionResultResponseHandlingStrategy handlingStrategy, IRequestHandler handler, PageRedirectRequest<?> pageRedirect, AjaxRequestTarget ajaxTarget, String url) {
    public static ActionResultResponse toDomainObjectPage(@NonNull ManagedObject entityOrViewmodel) {
        if (entityOrViewmodel == null) {
            throw new NullPointerException("entityOrViewmodel is marked non-null but is null");
        }
        PageRedirectRequest pageRedirectRequest = PageRedirectRequest.forPageClassAndBookmark(DomainObjectPage.class, (Bookmark)entityOrViewmodel.refreshBookmark().orElseThrow());
        return ActionResultResponse.toPage(pageRedirectRequest);
    }

    public static ActionResultResponse determineAndInterpretResult(ActionModel actionModel, @Nullable AjaxRequestTarget targetIfAny, @Nullable ManagedObject resultAdapter) {
        return _ResponseUtil.determineAndInterpretResult(actionModel, targetIfAny, resultAdapter);
    }

    static ActionResultResponse withHandler(IRequestHandler handler) {
        return new ActionResultResponse(ActionResultResponseHandlingStrategy.SCHEDULE_HANDLER, handler, null, null, null);
    }

    static ActionResultResponse toPage(PageRedirectRequest<?> page) {
        return new ActionResultResponse(ActionResultResponseHandlingStrategy.REDIRECT_TO_PAGE, null, page, null, null);
    }

    static ActionResultResponse openUrlInBrowser(AjaxRequestTarget ajaxTarget, String url, @NonNull OpenUrlStrategy openUrlStrategy) {
        if (openUrlStrategy == null) {
            throw new NullPointerException("openUrlStrategy is marked non-null but is null");
        }
        return new ActionResultResponse(openUrlStrategy.isNewWindow() ? ActionResultResponseHandlingStrategy.OPEN_URL_IN_NEW_BROWSER_WINDOW : ActionResultResponseHandlingStrategy.OPEN_URL_IN_SAME_BROWSER_WINDOW, null, null, ajaxTarget, url);
    }
}

